/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;

public abstract class UpgradeBase<T>
implements IUpgrade<T> {
    public UpgradeManager upgradeManager;
    public int dataHolderSlot;
    public Point openTabSize;

    public UpgradeBase(UpgradeManager manager, int dataHolderSlot, Point openTabSize) {
        this.upgradeManager = manager;
        this.dataHolderSlot = dataHolderSlot;
        this.openTabSize = openTabSize;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public int getDataHolderSlot() {
        return this.dataHolderSlot;
    }

    @Override
    public boolean isTabOpened() {
        return NbtHelper.getOrDefault(this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "TabOpen", false);
    }

    public ItemStack getDataHolderStack() {
        return this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot);
    }

    @Override
    public Point getTabSize() {
        if (this.isTabOpened()) {
            UpgradeBase upgradeBase = this;
            if (upgradeBase instanceof IFilter) {
                IFilter filter = (IFilter)((Object)upgradeBase);
                int rowCount = (int)Math.ceil((double)filter.getFilterSlotCount() / 3.0);
                return new Point(this.openTabSize.x(), this.openTabSize.y() - 18 * (3 - rowCount));
            }
            return this.openTabSize;
        }
        return new Point(24, 24);
    }

    public void updateDataHolderUnchecked(Consumer<ItemStack> updater) {
        ItemStack dataHolderStack = this.getDataHolderStack().m_41777_();
        if (dataHolderStack.m_41619_()) {
            return;
        }
        updater.accept(dataHolderStack);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public void updateDataHolderUnchecked(String dataKey, Object value) {
        ItemStack dataHolderStack = this.getDataHolderStack().m_41777_();
        if (dataHolderStack.m_41619_()) {
            return;
        }
        NbtHelper.set(dataHolderStack, dataKey, value);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public void setCooldown(int cooldown) {
        ItemStack dataHolderStack = this.getDataHolderStack().m_41777_();
        NbtHelper.set(dataHolderStack, "Cooldown", cooldown);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public int getCooldown() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "Cooldown", 100);
    }

    public boolean hasCooldown() {
        return NbtHelper.has(this.getDataHolderStack(), "Cooldown");
    }
}

