/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.magnet;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MagnetUpgrade
extends UpgradeBase<MagnetUpgrade>
implements IFilter,
IEnable,
ITickableUpgrade {
    public ItemStackHandler filter;
    private final MagnetFilterSettings filterSettings;

    public MagnetUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.filterSlotCount.get();
        this.filterSettings = new MagnetFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.m_41619_()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        List<Integer> filter = NbtHelper.getOrDefault(this.getDataHolderStack(), "FilterSettings", List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
        if (filter.size() != 3) {
            filter = List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1));
        }
        return filter;
    }

    public MagnetFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public int getFilterSlotCount() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.filterSlotCount.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new MagnetWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.filterSlotCount.get();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                    @Override
                    public boolean m_5857_(ItemStack pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.m_5857_(pStack);
                    }
                });
            }
        }
        return slots;
    }

    @Override
    public int getTickRate() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.tickRate.get();
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        this.teleportNearbyItems(player, level);
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    public void teleportNearbyItems(Player player, Level level) {
        if (level.f_46443_) {
            return;
        }
        int radius = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.pullRange.get();
        AABB area = new AABB(player.m_20182_().m_82520_((double)(-radius), (double)(-radius), (double)(-radius)), player.m_20182_().m_82520_((double)radius, (double)radius, (double)radius));
        List items = level.m_142425_((EntityTypeTest)EntityType.f_20461_, area, item -> !(!item.m_6084_() || level.f_46443_ && item.f_19797_ <= 1 || item.f_31988_ != null && item.f_31988_.equals(player.m_20148_()) && item.f_19797_ <= 80 || item.m_32055_().m_41619_() || item.getPersistentData().m_128441_("PreventRemoteMovement") || !this.getFilterSettings().matchesFilter(player, item.m_32055_())));
        items.forEach(item -> {
            item.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            item.m_32061_();
        });
    }

    private ItemStackHandler createFilter(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                MagnetUpgrade.this.updateDataHolderUnchecked("Inventory", MagnetUpgrade.this.filter);
                MagnetUpgrade.this.getFilterSettings().updateFilter((List)NbtHelper.get(MagnetUpgrade.this.getDataHolderStack(), "Inventory"));
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

