/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncItemStackPacket {
    private final int entityID;
    private final int slot;
    private final ItemStack itemStackInstance;
    private final CompoundTag map;

    public ClientboundSyncItemStackPacket(int entityId, int slot, ItemStack itemStackInstance, CompoundTag map) {
        this.entityID = entityId;
        this.slot = slot;
        ItemStack backpackCopy = itemStackInstance.m_41777_();
        backpackCopy.m_41751_(null);
        this.itemStackInstance = backpackCopy;
        this.map = map;
    }

    public static ClientboundSyncItemStackPacket decode(FriendlyByteBuf buffer) {
        int entityID = buffer.readInt();
        int slot = buffer.readInt();
        ItemStack itemStackInstance = buffer.m_130267_();
        CompoundTag map = buffer.m_130260_();
        return new ClientboundSyncItemStackPacket(entityID, slot, itemStackInstance, map);
    }

    public static void encode(ClientboundSyncItemStackPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityID);
        buffer.writeInt(message.slot);
        buffer.m_130055_(message.itemStackInstance);
        buffer.m_130079_(message.map);
    }

    public static void handle(ClientboundSyncItemStackPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player = (Player)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.entityID);
            if (player != null && message.slot == -1) {
                AbstractContainerMenu patt2306$temp = player.f_36096_;
                if (patt2306$temp instanceof BackpackBaseMenu) {
                    BackpackBaseMenu menu = (BackpackBaseMenu)patt2306$temp;
                    ItemStack oldStack = menu.getWrapper().getBackpackStack().m_41777_();
                    for (String key : message.map.m_128431_()) {
                        oldStack.m_41784_().m_128365_(key, message.map.m_128423_(key));
                    }
                    menu.getWrapper().setBackpackStack(oldStack);
                    return;
                }
                return;
            }
            if (player != null && ((ItemStack)player.m_150109_().f_35974_.get(message.slot)).m_150930_(message.itemStackInstance.m_41720_())) {
                int changedMode;
                ItemStack oldStack = ((ItemStack)player.m_150109_().f_35974_.get(message.slot)).m_41777_();
                for (String key : message.map.m_128431_()) {
                    ((ItemStack)player.m_150109_().f_35974_.get(message.slot)).m_41784_().m_128365_(key, message.map.m_128423_(key));
                }
                ItemStack newStack = ((ItemStack)player.m_150109_().f_35974_.get(message.slot)).m_41777_();
                AbstractContainerMenu patt3377$temp = player.f_36096_;
                if (patt3377$temp instanceof BackpackBaseMenu) {
                    BackpackBaseMenu menu = (BackpackBaseMenu)patt3377$temp;
                    menu.getWrapper().setBackpackStack((ItemStack)player.m_150109_().f_35974_.get(message.slot));
                }
                if (message.map.m_128441_("HoseModes") && (changedMode = ClientboundSyncItemStackPacket.getChangedMode(oldStack, newStack)) != -1) {
                    player.m_5661_(ClientboundSyncItemStackPacket.getNextModeMessage(changedMode, NbtHelper.deserializeIntList(message.map, "HoseModes").get(changedMode)), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static int getChangedMode(ItemStack oldStack, ItemStack newStack) {
        if (NbtHelper.getOrDefault(oldStack, "HoseModes", List.of(Integer.valueOf(0), Integer.valueOf(0))).get(0).intValue() != NbtHelper.getOrDefault(newStack, "HoseModes", List.of(Integer.valueOf(0), Integer.valueOf(0))).get(0).intValue()) {
            return 0;
        }
        if (NbtHelper.getOrDefault(oldStack, "HoseModes", List.of(Integer.valueOf(0), Integer.valueOf(0))).get(1).intValue() != NbtHelper.getOrDefault(newStack, "HoseModes", List.of(Integer.valueOf(0), Integer.valueOf(0))).get(1).intValue()) {
            return 1;
        }
        return -1;
    }

    public static Component getNextModeMessage(int changedMode, int data) {
        if (changedMode == 0) {
            if (data == 2) {
                return Component.m_237115_((String)"item.travelersbackpack.hose.spill");
            }
            if (data == 3) {
                return Component.m_237115_((String)"item.travelersbackpack.hose.drink");
            }
            return Component.m_237115_((String)"item.travelersbackpack.hose.suck");
        }
        if (data == 1) {
            return Component.m_237115_((String)"item.travelersbackpack.hose.tank_left");
        }
        return Component.m_237115_((String)"item.travelersbackpack.hose.tank_right");
    }
}

