/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSlotPacket {
    private final int selectType;
    private final List<?> slotsData;
    public static final int UNSORTABLES = 0;
    public static final int MEMORY = 1;

    public ServerboundSlotPacket(int selectType, List<?> slotsData) {
        this.selectType = selectType;
        this.slotsData = slotsData;
    }

    public static ServerboundSlotPacket decode(FriendlyByteBuf buffer) {
        int selectType = buffer.readInt();
        List<Object> slotsData = new ArrayList();
        if (selectType == 0) {
            slotsData = buffer.m_178338_().intStream().boxed().collect(Collectors.toList());
        }
        if (selectType == 1) {
            slotsData = NbtHelper.deserializeMemorySlotsPacket(buffer.m_130260_());
        }
        return new ServerboundSlotPacket(selectType, slotsData);
    }

    public static void encode(ServerboundSlotPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.selectType);
        List<Pair<Integer, Boolean>> slotsData = message.slotsData;
        if (message.selectType == 0) {
            List<Pair<Integer, Boolean>> unsortables = slotsData;
            buffer.m_178345_((IntList)new IntArrayList(unsortables.stream().mapToInt(Integer::intValue).toArray()));
        }
        if (message.selectType == 1) {
            buffer.m_130079_(NbtHelper.serializeMemorySlotsPacket(slotsData));
        }
    }

    public static void handle(ServerboundSlotPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                AbstractContainerMenu patt2431$temp = serverPlayer.f_36096_;
                if (patt2431$temp instanceof BackpackSettingsMenu) {
                    BackpackSettingsMenu menu = (BackpackSettingsMenu)patt2431$temp;
                    String syncKey = null;
                    if (message.selectType == 0) {
                        menu.getWrapper().setUnsortableSlots(message.slotsData);
                        syncKey = "UnsortableSlots";
                    }
                    if (message.selectType == 1) {
                        List<Pair<Integer, Pair<ItemStack, Boolean>>> oldMemoryStacks = menu.getWrapper().getMemorySlots();
                        ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>> memoryStacks = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
                        for (Pair memorizedSlot : message.slotsData) {
                            ItemStack retrievedStack;
                            ItemStack itemStack = retrievedStack = (Boolean)memorizedSlot.getSecond() != false ? menu.m_38853_((Integer)memorizedSlot.getFirst()).m_7993_() : menu.m_38853_((Integer)memorizedSlot.getFirst()).m_7993_().m_41720_().m_7968_();
                            if (retrievedStack.m_41619_()) {
                                for (Pair<Integer, Pair<ItemStack, Boolean>> oldMemorizedSlot : oldMemoryStacks) {
                                    if (!((Integer)oldMemorizedSlot.getFirst()).equals(memorizedSlot.getFirst())) continue;
                                    retrievedStack = (ItemStack)((Pair)oldMemorizedSlot.getSecond()).getFirst();
                                    break;
                                }
                            }
                            if (retrievedStack.m_41619_()) continue;
                            memoryStacks.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)((Integer)memorizedSlot.getFirst()), (Object)Pair.of((Object)retrievedStack, (Object)((Boolean)memorizedSlot.getSecond()))));
                        }
                        menu.getWrapper().setMemorySlots(memoryStacks);
                        syncKey = "MemorySlots";
                    }
                    if (syncKey != null) {
                        menu.getWrapper().sendDataToClients(syncKey);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

