/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outer_end.feature.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ShapeUtil {
    public static List<BlockPos> generateCircle(float radius) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        float thetaIncrement = 1.0f / radius;
        float theta = 0.0f;
        while ((double)theta < Math.PI * 2) {
            posList.add(new BlockPos((int)(Mth.m_14089_((float)theta) * radius), 0, (int)(Mth.m_14031_((float)theta) * radius)));
            theta += thetaIncrement;
        }
        return posList;
    }

    public static List<BlockPos> generateSolidCircle(float radius) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int x = (int)(-radius);
        while ((float)x < radius) {
            int z = (int)(-radius);
            while ((float)z < radius) {
                if ((float)(x * x + z * z) <= radius * radius) {
                    posList.add(new BlockPos(x, 0, z));
                }
                ++z;
            }
            ++x;
        }
        return posList;
    }

    public static List<BlockPos> generateSolidSphere(float radius) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int x = (int)(-radius);
        while ((float)x < radius) {
            int y = (int)(-radius);
            while ((float)y < radius) {
                int z = (int)(-radius);
                while ((float)z < radius) {
                    if ((float)(x * x + y * y + z * z) <= radius * radius) {
                        posList.add(new BlockPos(x, y, z));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return posList;
    }

    public static List<BlockPos> generateLine(BlockPos startPos, BlockPos endPos) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        Vec3 vec1 = new Vec3((double)startPos.m_123341_(), (double)startPos.m_123342_(), (double)startPos.m_123343_());
        Vec3 vec2 = new Vec3((double)endPos.m_123341_(), (double)endPos.m_123342_(), (double)endPos.m_123343_());
        Vec3 diffVec = vec2.m_82546_(vec1);
        Vec3 incVec = new Vec3((double)((int)diffVec.f_82479_) / diffVec.m_82553_(), (double)((int)diffVec.f_82480_) / diffVec.m_82553_(), (double)((int)diffVec.f_82481_) / diffVec.m_82553_());
        for (int i = 0; i <= (int)diffVec.m_82553_(); ++i) {
            posList.add(new BlockPos((int)vec1.f_82479_, (int)vec1.f_82480_, (int)vec1.f_82481_));
            vec1 = vec1.m_82549_(incVec);
        }
        return posList;
    }
}

