/*
 * Decompiled with CFR 0.152.
 */
package com.periut.cryonicconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.periut.cryonicconfig.ConfigStorage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

public final class UtilityCryonicConfig {
    public static final String MOD_ID = "cryonicconfig";
    public static final HashMap<String, ConfigStorage> SERVER_CONFIG = new HashMap();
    public static final HashMap<String, ConfigStorage> LOCAL_CONFIG = new HashMap();
    private static String dir;

    public static void init(String dir) {
        File mainConfigFile;
        UtilityCryonicConfig.dir = dir + "/config";
        File configDir = new File((String)UtilityCryonicConfig.dir);
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if ((mainConfigFile = new File(configDir, "cryonicconfig.json")).exists()) {
            try (BufferedReader reader = Files.newBufferedReader(mainConfigFile.toPath());){
                Gson gson = new Gson();
                Map configMappings = (Map)gson.fromJson((Reader)reader, HashMap.class);
                if (configMappings != null) {
                    for (Map.Entry entry : configMappings.entrySet()) {
                        String modId = (String)entry.getKey();
                        String configFileName = (String)entry.getValue();
                        String fullPath = UtilityCryonicConfig.dir + "/" + configFileName;
                        ConfigStorage configStorage = new ConfigStorage(modId);
                        configStorage.loadFromFile(fullPath);
                        LOCAL_CONFIG.put(modId, configStorage);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap<String, CallSite> configMappings = new HashMap<String, CallSite>();
        for (Map.Entry<String, ConfigStorage> entry : LOCAL_CONFIG.entrySet()) {
            String modId = entry.getKey();
            ConfigStorage configStorage = entry.getValue();
            String configFileName = modId + ".json";
            configMappings.put(modId, (CallSite)((Object)configFileName));
            String fullPath = dir + "/" + configFileName;
            configStorage.saveToFile(fullPath);
        }
        try (FileWriter writer = new FileWriter(dir + "/cryonicconfig.json");){
            gson.toJson(configMappings, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void handleSyncMessage(String mod_id, String key, String value) {
        ConfigStorage serverConfig = SERVER_CONFIG.computeIfAbsent(mod_id, k -> new ConfigStorage(mod_id));
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            serverConfig.setBoolean(key, Boolean.parseBoolean(value));
        } else {
            try {
                if (value.contains(".")) {
                    serverConfig.setDouble(key, Double.parseDouble(value));
                } else {
                    serverConfig.setInt(key, Integer.parseInt(value));
                }
            }
            catch (NumberFormatException e) {
                serverConfig.setString(key, value);
            }
        }
    }
}

