/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;

public class CragLakeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public CragLakeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        ImprovedNoise noiseSampler = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(context.m_159774_().m_6018_().m_7328_()));
        ImprovedNoise lakeDepthSampler = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(context.m_159774_().m_6018_().m_7328_() + 2439854945L));
        WorldGenLevel level = context.m_159774_();
        ChunkAccess chunk = level.m_46865_(context.m_159777_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        ChunkPos pos = chunk.m_7697_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int offsetHeight;
                double noiseWaterThreshold;
                int worldX = pos.m_151382_(x);
                int worldZ = pos.m_151391_(z);
                int heightmap = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
                double noise = CragLakeFeature.getNoise(noiseSampler, worldX, worldZ);
                if (!(noise < (noiseWaterThreshold = 0.35))) continue;
                mutable.m_122178_(worldX, heightmap, worldZ);
                if (!chunk.m_8055_((BlockPos)mutable).m_60815_()) continue;
                boolean mayPlace = true;
                for (Direction direction : DIRECTIONS) {
                    mutable.m_122178_(worldX, heightmap, worldZ).m_122173_(direction);
                    BlockState offsetState = level.m_8055_((BlockPos)mutable);
                    if (offsetState.m_60815_() || offsetState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                    mayPlace = false;
                    break;
                }
                boolean hasWaterfall = false;
                if (!mayPlace) {
                    for (Direction direction : DIRECTIONS) {
                        double offsetNoise;
                        mutable.m_122178_(worldX, heightmap, worldZ).m_122173_(direction);
                        offsetHeight = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutable.m_123341_(), mutable.m_123343_());
                        if (offsetHeight >= heightmap || !((offsetNoise = CragLakeFeature.getNoise(noiseSampler, mutable.m_123341_(), mutable.m_123343_())) < noiseWaterThreshold)) continue;
                        mayPlace = true;
                        hasWaterfall = true;
                    }
                }
                for (Direction direction : DIRECTIONS) {
                    mutable.m_122178_(worldX, 0, worldZ).m_122173_(direction);
                    offsetHeight = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutable.m_123341_(), mutable.m_123343_());
                    mutable.m_142448_(offsetHeight);
                    if (level.m_204166_((BlockPos)mutable).m_203565_(BWGBiomes.CRAG_GARDENS)) continue;
                    mayPlace = false;
                    break;
                }
                if (!mayPlace) continue;
                if (!hasWaterfall) {
                    double depthDelta = noise / (noiseWaterThreshold * 0.5);
                    double clampedDelta = Mth.m_14008_((double)depthDelta, (double)0.0, (double)1.0);
                    double normalizedLakeDepth = (lakeDepthSampler.m_164308_((double)mutable.m_123341_() * 0.3, 0.0, (double)mutable.m_123343_() * 0.3) + 1.0) * 0.5;
                    double lakeDepth = BlendingFunction.EaseInOutCirc.INSTANCE.apply(clampedDelta, 1.0, normalizedLakeDepth * 5.0);
                    mutable.m_122178_(worldX, heightmap, worldZ);
                    chunk.m_6978_((BlockPos)mutable, Blocks.f_49990_.m_49966_(), false);
                    level.m_186469_(mutable.m_7949_(), (Fluid)Fluids.f_76193_, 0);
                    chunk.m_8113_((BlockPos)mutable.m_122173_(Direction.UP));
                    chunk.m_8113_((BlockPos)mutable.m_122173_(Direction.UP));
                    int lakeY = 1;
                    while ((double)lakeY < lakeDepth) {
                        mutable.m_122178_(worldX, heightmap - lakeY, worldZ);
                        chunk.m_6978_((BlockPos)mutable, Blocks.f_49990_.m_49966_(), false);
                        level.m_186469_(mutable.m_7949_(), (Fluid)Fluids.f_76193_, 0);
                        ++lakeY;
                    }
                    continue;
                }
                mutable.m_122178_(worldX, heightmap, worldZ);
                chunk.m_6978_((BlockPos)mutable, Blocks.f_49990_.m_49966_(), false);
                level.m_186469_(mutable.m_7949_(), (Fluid)Fluids.f_76193_, 0);
                chunk.m_8113_((BlockPos)mutable.m_122173_(Direction.UP));
                chunk.m_8113_((BlockPos)mutable.m_122173_(Direction.UP));
            }
        }
        return true;
    }

    private static double getNoise(ImprovedNoise noiseSampler, int worldX, int worldZ) {
        double freq = 0.05;
        return (noiseSampler.m_164308_((double)worldX * freq, 0.0, (double)worldZ * freq) + 1.0) * 0.5;
    }
}

