/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.client.render.ElevatorBakedModel;
import xyz.vsngamer.elevatorid.init.Registry;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;

public class ElevatorTileEntity
extends BlockEntity
implements MenuProvider {
    private BlockState heldState;

    public ElevatorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.ELEVATOR_TILE_ENTITY.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("held_id")) {
            BlockState state = NbtUtils.m_247651_((HolderGetter)(this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_()), (CompoundTag)tag.m_128469_("held_id"));
            this.heldState = ElevatorTileEntity.isValidState(state) ? state : null;
        } else {
            this.heldState = null;
        }
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.heldState != null) {
            tag.m_128365_("held_id", (Tag)NbtUtils.m_129202_((BlockState)this.heldState));
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ElevatorBakedModel.HELD_STATE, (Object)this.heldState).build();
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.markUpdated();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)"screen.elevatorid.elevator");
    }

    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new ElevatorContainer(id, this.f_58858_, player);
    }

    public void setHeldState(BlockState state) {
        this.heldState = state;
        this.markUpdated();
    }

    private void markUpdated() {
        this.m_6596_();
        this.requestModelDataUpdate();
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.m_58900_().m_60701_((LevelAccessor)this.f_58857_, this.f_58858_, 2);
        this.f_58857_.m_5518_().m_7174_(this.f_58858_);
    }

    public BlockState getHeldState() {
        return this.heldState;
    }

    public boolean setCamoAndUpdate(BlockState newState) {
        if (this.heldState == newState) {
            return false;
        }
        if (!ElevatorTileEntity.isValidState(newState)) {
            return false;
        }
        this.setHeldState(newState);
        if (this.m_58904_() != null) {
            this.m_58904_().m_5594_(null, this.m_58899_(), (SoundEvent)Registry.CAMOUFLAGE_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public static boolean isValidState(BlockState state) {
        if (state == null) {
            return true;
        }
        if (state.m_60734_() == Blocks.f_50016_) {
            return false;
        }
        if (state.m_155947_()) {
            return false;
        }
        if (state.m_60734_() instanceof ElevatorBlock) {
            return false;
        }
        if (state.m_60799_() != RenderShape.MODEL) {
            return false;
        }
        return !state.m_60812_(null, null).m_83281_();
    }
}

