/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.common.util.ExpandNewLineTextAcceptor;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.core.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public final class StringUtil {
    private StringUtil() {
    }

    public static Component stripStyling(Component textComponent) {
        MutableComponent text = textComponent.m_6879_();
        for (Component sibling : textComponent.m_7360_()) {
            text.m_7220_(StringUtil.stripStyling(sibling));
        }
        return text;
    }

    public static String removeChatFormatting(String string) {
        String result = ChatFormatting.m_126649_((String)string);
        return result == null ? "" : result;
    }

    public static FormattedText truncateStringToWidth(FormattedText text, int width, Font font) {
        int ellipsisWidth = font.m_92895_("...");
        StringSplitter splitter = font.m_92865_();
        FormattedText truncatedText = font.m_92854_(text, width - ellipsisWidth);
        Style style = splitter.m_92386_(text, width - ellipsisWidth);
        if (style == null) {
            style = Style.f_131099_;
        }
        return FormattedText.m_130773_((FormattedText[])new FormattedText[]{truncatedText, Component.m_237113_((String)"...").m_6270_(style)});
    }

    public static Pair<List<FormattedText>, Boolean> splitLines(Font font, List<FormattedText> lines, int width, int maxLines) {
        if (lines.isEmpty()) {
            return new Pair<List<FormattedText>, Boolean>(List.of(), false);
        }
        if (maxLines <= 0) {
            return new Pair<List<FormattedText>, Boolean>(List.of(), true);
        }
        if (width <= 0) {
            return new Pair<List<FormattedText>, Boolean>(List.copyOf(lines), false);
        }
        StringSplitter splitter = font.m_92865_();
        ArrayList<FormattedText> result = new ArrayList<FormattedText>();
        for (FormattedText line : lines) {
            List splitLines = line.getString().isEmpty() ? List.of(line) : splitter.m_92414_(line, width, Style.f_131099_);
            for (FormattedText splitLine : splitLines) {
                if (result.size() == maxLines) {
                    FormattedText last = (FormattedText)result.remove(result.size() - 1);
                    last = StringUtil.truncateStringToWidth(last, width, font);
                    result.add(last);
                    return new Pair<List<FormattedText>, Boolean>(result, true);
                }
                result.add(splitLine);
            }
        }
        return new Pair<List<FormattedText>, Boolean>(result, false);
    }

    public static List<FormattedText> expandNewlines(Component ... descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        for (Component descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.m_7451_((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.f_131099_);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }

    public static String intsToString(Collection<Integer> indexes) {
        return indexes.stream().sorted().map(i -> Integer.toString(i)).collect(Collectors.joining(", "));
    }

    public static void drawCenteredStringWithShadow(GuiGraphics guiGraphics, Font font, String string, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
        guiGraphics.m_280488_(font, string, textArea.getX(), textArea.getY(), -1);
    }

    public static void drawCenteredStringWithShadow(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, text);
        guiGraphics.m_280648_(font, text, textArea.getX(), textArea.getY(), -1);
    }
}

