/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.subtypes;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;

public class SubtypeInterpreters {
    private final Map<Object, IIngredientSubtypeInterpreter<?>> map = new IdentityHashMap();

    public <B, I> boolean addInterpreter(IIngredientTypeWithSubtypes<B, I> type, B base, IIngredientSubtypeInterpreter<I> interpreter) {
        if (!type.getIngredientBaseClass().isInstance(base)) {
            throw new IllegalArgumentException(String.format("base must be instance of %s but got %s instead", type.getIngredientBaseClass(), base.getClass()));
        }
        if (this.map.containsKey(base)) {
            return false;
        }
        this.map.put(base, interpreter);
        return true;
    }

    public <B, I> Optional<IIngredientSubtypeInterpreter<I>> get(IIngredientTypeWithSubtypes<B, I> type, I ingredient) {
        IIngredientSubtypeInterpreter<?> interpreter;
        B base = type.getBase(ingredient);
        IIngredientSubtypeInterpreter<?> cast = interpreter = this.map.get(base);
        return Optional.ofNullable(cast);
    }

    public <B, T> boolean contains(IIngredientTypeWithSubtypes<B, T> type, T ingredient) {
        B base = type.getBase(ingredient);
        return this.map.containsKey(base);
    }
}

