/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.server.ai;

import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.animation.EMAnimatedEntity;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.jetbrains.annotations.NotNull;

public class AnimationMeleeAI<T extends EEEABMobLibrary>
extends MeleeAttackGoal {
    protected T attacker;
    protected final double speed;
    protected int ticksUntilNextAttack;
    protected final Supplier<Animation>[] animations;
    protected final Predicate<T> customFlag;
    protected int attackInterval = 10;

    @SafeVarargs
    public AnimationMeleeAI(T attacker, double speed, Supplier<Animation> ... animations) {
        this((EEEABMobLibrary)attacker, speed, (T e) -> e.active, animations);
    }

    @SafeVarargs
    public AnimationMeleeAI(T attacker, double speed, int attackInterval, Supplier<Animation> ... animations) {
        this((EEEABMobLibrary)attacker, speed, (T e) -> e.active, animations);
        this.attackInterval = attackInterval;
    }

    @SafeVarargs
    public AnimationMeleeAI(T attacker, double speed, int attackInterval, Predicate<T> customFlag, Supplier<Animation> ... animations) {
        this(attacker, speed, customFlag, animations);
        this.attackInterval = attackInterval;
    }

    @SafeVarargs
    public AnimationMeleeAI(T attacker, double speed, Predicate<T> customFlag, Supplier<Animation> ... animations) {
        super(attacker, speed, true);
        this.attacker = attacker;
        this.speed = speed;
        this.customFlag = customFlag;
        this.animations = animations;
    }

    public boolean m_8036_() {
        if (!this.customFlag.test(this.attacker)) {
            return false;
        }
        return super.m_8036_();
    }

    public boolean m_8045_() {
        if (!this.customFlag.test(this.attacker)) {
            return false;
        }
        return super.m_8045_();
    }

    public void m_8037_() {
        if (this.attacker.m_5448_() != null && ((EEEABMobLibrary)this.attacker).isNoAnimation()) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
        super.m_8037_();
    }

    protected void m_6739_(@NotNull LivingEntity target, double distToEnemySqr) {
        if (((EEEABMobLibrary)this.attacker).isNoAnimation() && this.ticksUntilNextAttack == 0 && this.attacker.m_142593_(target) >= distToEnemySqr) {
            this.ticksUntilNextAttack = this.m_25566_();
            ((EEEABMobLibrary)this.attacker).playAnimation(this.getAnimationByRandom());
        }
    }

    protected int m_25566_() {
        return this.m_183277_(this.attackInterval);
    }

    private Animation getAnimationByRandom() {
        if (this.animations == null || this.animations.length == 0) {
            return EMAnimatedEntity.NO_ANIMATION;
        }
        return this.animations[this.attacker.m_217043_().m_188503_(this.animations.length)].get();
    }
}

