/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.effects;

import com.eeeab.eeeabsmobs.client.render.EMRenderType;
import com.eeeab.eeeabsmobs.client.render.FlatTextureRenderer;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityImmortalMagicCircle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class RenderImmortalMagicCircle
extends FlatTextureRenderer<EntityImmortalMagicCircle> {
    private static final ResourceLocation NONE_TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/immortal_magic_circle/none.png");
    private static final ResourceLocation SPEED_TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/immortal_magic_circle/speed.png");
    private static final ResourceLocation POWER_TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/immortal_magic_circle/power.png");
    private static final ResourceLocation HARMFUL_TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/immortal_magic_circle/harmful.png");
    private static final ResourceLocation BENEFICIAL_TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/immortal_magic_circle/beneficial.png");

    public RenderImmortalMagicCircle(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(EntityImmortalMagicCircle entity) {
        return switch (entity.getMagicCircleType()) {
            case EntityImmortalMagicCircle.MagicCircleType.SPEED -> SPEED_TEXTURE;
            case EntityImmortalMagicCircle.MagicCircleType.POWER -> POWER_TEXTURE;
            case EntityImmortalMagicCircle.MagicCircleType.HARMFUL -> HARMFUL_TEXTURE;
            case EntityImmortalMagicCircle.MagicCircleType.BENEFICIAL -> BENEFICIAL_TEXTURE;
            default -> NONE_TEXTURE;
        };
    }

    public void render(EntityImmortalMagicCircle entity, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer consumer = bufferIn.m_6299_(EMRenderType.getGlowingEffect(this.getTextureLocation(entity)));
        matrixStackIn.m_85836_();
        float speed = ((float)entity.f_19797_ + delta) * entity.getSpeed();
        float scale = entity.NO ? entity.getScale() * entity.processController.getAnimationFraction(delta) : entity.getScale();
        float alpha = entity.NO ? 1.0f : entity.processController.getAnimationFraction(delta);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-entity.getYaw() + 180.0f + speed));
        matrixStackIn.m_85837_(0.0, (double)0.001f, 0.0);
        matrixStackIn.m_85841_(-scale, -scale, -scale);
        this.renderFlatQuad(matrixStackIn, consumer, packedLightIn, alpha, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, FlatTextureRenderer.Quad.XZ);
        matrixStackIn.m_85849_();
    }
}

