/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.effects;

import com.eeeab.eeeabsmobs.client.render.EMRenderType;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityScorch;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderScorch
extends EntityRenderer<EntityScorch> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/scorch.png");
    private static final float TEXTURE_WIDTH = 32.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float RING_FRAME_SIZE = 16.0f;
    private static final float LINGER_RADIUS = 1.0f;
    private static final float SCORCH_MIN_U = 0.0f;
    private static final float SCORCH_MAX_U = 0.5f;
    private static final float SCORCH_MIN_V = 0.0f;
    private static final float SCORCH_MAX_V = 0.5f;

    public RenderScorch(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EntityScorch scorch, float entityYaw, float delta, PoseStack poseStack, MultiBufferSource bufferIn, int packedLight) {
        poseStack.m_85836_();
        float opacity = ((float)scorch.controlled.getTimer() + delta) * 0.1f;
        if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        VertexConsumer vertexConsumer = bufferIn.m_6299_(EMRenderType.m_110473_((ResourceLocation)TEXTURE));
        this.drawScorch(scorch, delta, poseStack, vertexConsumer, packedLight, opacity);
        poseStack.m_85849_();
    }

    private void drawScorch(EntityScorch scorch, float delta, PoseStack matrixStack, VertexConsumer builder, int packedLightIn, float opacity) {
        Level world = scorch.m_20193_();
        double ex = scorch.f_19790_ + (scorch.m_20185_() - scorch.f_19790_) * (double)delta;
        double ey = scorch.f_19791_ + (scorch.m_20186_() - scorch.f_19791_) * (double)delta;
        double ez = scorch.f_19792_ + (scorch.m_20189_() - scorch.f_19792_) * (double)delta;
        int minX = Mth.m_14107_((double)(ex - 1.0));
        int maxX = Mth.m_14107_((double)(ex + 1.0));
        int minY = Mth.m_14107_((double)(ey - 1.0));
        int maxY = Mth.m_14107_((double)ey);
        int minZ = Mth.m_14107_((double)(ez - 1.0));
        int maxZ = Mth.m_14107_((double)(ez + 1.0));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(minX, minY, minZ), (BlockPos)new BlockPos(maxX, maxY, maxZ))) {
            BlockState block = world.m_8055_(pos.m_7495_());
            if (block.m_60795_() || world.m_46803_(pos) <= 3) continue;
            this.drawScorchBlock(world, block, pos, ex, ey, ez, matrixStack, builder, packedLightIn, opacity);
        }
    }

    private void drawScorchBlock(Level world, BlockState block, BlockPos pos, double ex, double ey, double ez, PoseStack matrixStack, VertexConsumer builder, int packedLightIn, float opacity) {
        PoseStack.Pose matrixstack$entry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        if (block.m_60796_((BlockGetter)world, pos)) {
            int bx = pos.m_123341_();
            int by = pos.m_123342_();
            int bz = pos.m_123343_();
            VoxelShape shape = block.m_60816_((BlockGetter)world, pos);
            if (!shape.m_83281_()) {
                AABB aabb = shape.m_83215_();
                float minX = (float)((double)bx + aabb.f_82288_ - ex);
                float maxX = (float)((double)bx + aabb.f_82291_ - ex);
                float y = (float)((double)by + aabb.f_82289_ - ey + 0.015625);
                float minZ = (float)((double)bz + aabb.f_82290_ - ez);
                float maxZ = (float)((double)bz + aabb.f_82293_ - ez);
                float minU = (minX / 2.0f / 1.0f + 0.5f) * 0.5f + 0.0f;
                float maxU = (maxX / 2.0f / 1.0f + 0.5f) * 0.5f + 0.0f;
                float minV = (minZ / 2.0f / 1.0f + 0.5f) * 0.5f + 0.0f;
                float maxV = (maxZ / 2.0f / 1.0f + 0.5f) * 0.5f + 0.0f;
                this.drawVertex(matrix4f, matrix3f, builder, minX, y, minZ, minU, minV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, minX, y, maxZ, minU, maxV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, maxX, y, maxZ, maxU, maxV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, maxX, y, minZ, maxU, minV, opacity, packedLightIn);
            }
        }
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(EntityScorch entity) {
        return TEXTURE;
    }
}

