/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity;

import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.animation.EMAnimatedEntity;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.ArrayUtils;

public abstract class EEEABMobLibrary
extends EEEABMobEntity
implements EMAnimatedEntity,
IEntityAdditionalSpawnData {
    private int animationTick;
    private Animation animation = NO_ANIMATION;
    public boolean canplayHurtAnimation = true;
    public boolean hurtInterruptsAnimation = false;

    public EEEABMobLibrary(EntityType<? extends EEEABMobLibrary> type, Level level) {
        super(type, level);
    }

    public Animation getDeathAnimation() {
        return null;
    }

    public Animation getHurtAnimation() {
        return null;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        boolean attack = super.m_6469_(source, damage);
        if (attack && this.m_21223_() > 0.0f && (this.isNoAnimation() || this.hurtInterruptsAnimation) && this.canplayHurtAnimation) {
            this.playAnimation(this.getHurtAnimation());
        }
        return attack;
    }

    @Override
    protected void dying() {
        if (this.getDeathAnimation() != null && this.getAnimation() != this.getDeathAnimation()) {
            this.stopAllSuperpositionAnimation();
            this.playAnimation(this.getDeathAnimation());
        }
    }

    @Override
    protected int getDeathDuration() {
        Animation death = this.getDeathAnimation();
        if (death != null) {
            return death.getDuration();
        }
        return 20;
    }

    public void playAnimation(Animation animation) {
        if (animation != null) {
            EMAnimationHandler.INSTANCE.sendEMAnimationMessage(this, animation);
        }
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        if (animation != NO_ANIMATION) {
            this.onAnimationStart(animation);
        } else {
            this.onAnimationFinish(this.animation);
        }
        this.animation = animation;
    }

    public boolean isNoAnimation() {
        return this.animation == NO_ANIMATION;
    }

    public void stopAllSuperpositionAnimation() {
        EMAnimationHandler.INSTANCE.sendEMAnimationMessage(this, true);
    }

    protected void onAnimationStart(Animation animation) {
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)((Object)this.getAnimation())));
        buffer.writeInt(this.getAnimationTick());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.f_19859_ = this.m_146908_();
        this.f_20883_ = this.f_20886_ = this.f_20885_;
        this.f_20884_ = this.f_20886_;
        int animOrdinal = additionalData.readInt();
        int animTick = additionalData.readInt();
        this.setAnimation(animOrdinal == -1 ? NO_ANIMATION : this.getAnimations()[animOrdinal]);
        this.setAnimationTick(animTick);
    }
}

