/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public interface IRopeConnection {
    default public boolean shouldConnectToFace(BlockState thisState, BlockState facingState, BlockPos facingPos, Direction dir, LevelReader world) {
        if (!this.canSideAcceptConnection(thisState, dir)) {
            return false;
        }
        switch (dir) {
            case UP: {
                return IRopeConnection.isSupportingCeiling(facingState, facingPos, world);
            }
            case DOWN: {
                return IRopeConnection.isSupportingCeiling(facingPos.m_6630_(2), world) || IRopeConnection.canConnectDown(facingState);
            }
        }
        if (CommonConfigs.Functional.ROPE_UNRESTRICTED.get().booleanValue() && facingState.m_60783_((BlockGetter)world, facingPos, dir.m_122424_())) {
            return true;
        }
        Block block = facingState.m_60734_();
        if (block instanceof IRopeConnection) {
            IRopeConnection otherRope = (IRopeConnection)block;
            return otherRope.canSideAcceptConnection(facingState, dir.m_122424_());
        }
        return false;
    }

    public boolean canSideAcceptConnection(BlockState var1, Direction var2);

    public static boolean isSupportingCeiling(BlockPos pos, LevelReader world) {
        return IRopeConnection.isSupportingCeiling(world.m_8055_(pos), pos, world);
    }

    public static boolean canConnectDown(BlockState downState) {
        Block b = downState.m_60734_();
        if (b instanceof IRopeConnection) {
            IRopeConnection ropeConnection = (IRopeConnection)b;
            return ropeConnection.canSideAcceptConnection(downState, Direction.UP);
        }
        return downState.m_204336_(ModTags.ROPE_HANG_TAG) || downState.m_61138_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) && downState.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) == AttachFace.CEILING || b instanceof ChainBlock && downState.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y || downState.m_61138_((Property)BlockStateProperties.f_61435_) && (Boolean)downState.m_61143_((Property)BlockStateProperties.f_61435_) != false;
    }

    public static boolean isSupportingCeiling(BlockState upState, BlockPos pos, LevelReader world) {
        Block block = upState.m_60734_();
        if (block instanceof IRopeConnection) {
            IRopeConnection ropeConnection = (IRopeConnection)block;
            return ropeConnection.canSideAcceptConnection(upState, Direction.DOWN);
        }
        return Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)Direction.DOWN) && upState.m_280296_() || upState.m_204336_(ModTags.ROPE_SUPPORT_TAG);
    }
}

