/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.forge;

import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.mehvahdjukaar.supplementaries.common.fluids.FlammableLiquidBlock;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class LumiseneBucketItem
extends BucketItem {
    private final int capacity;

    public LumiseneBucketItem(Supplier<? extends FiniteFluid> supplier, Item.Properties builder, int capacity) {
        super(supplier, builder);
        this.capacity = capacity;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        BlockPos blockpos2;
        BlockHitResult blockhitresult;
        ItemStack itemstack = player.m_21120_(usedHand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)itemstack, (HitResult)(blockhitresult = LumiseneBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)));
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos hitPos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos above = hitPos.m_121945_(direction);
        if (!level.m_7966_(player, hitPos) || !player.m_36204_(above, direction, itemstack)) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        BlockState blockstate = level.m_8055_(hitPos);
        BlockPos blockPos = blockpos2 = this.canBlockContainFluid(level, hitPos, blockstate) ? hitPos : above;
        if (this.emptyContents(player, level, blockpos2, blockhitresult, itemstack)) {
            this.m_142131_(player, level, itemstack, blockpos2);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_285767_(sp, blockpos2, itemstack);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)LumiseneBucketItem.m_40699_((ItemStack)itemstack, (Player)player), (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean emptyContents(@Nullable Player arg, Level level, BlockPos pos, @Nullable BlockHitResult hitResult, @Nullable ItemStack container) {
        BlockState newState;
        LiquidBlockContainer lc;
        LiquidBlockContainer lc2;
        Fluid myFluid = this.getFluid();
        BlockState stateAt = level.m_8055_(pos);
        Block blockAt = stateAt.m_60734_();
        boolean canReplaceBlock = stateAt.m_60722_(myFluid);
        boolean canFillBlock = stateAt.m_60795_() || canReplaceBlock || blockAt instanceof LiquidBlockContainer && (lc2 = (LiquidBlockContainer)blockAt).m_6044_((BlockGetter)level, pos, stateAt, myFluid);
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        if (!canFillBlock) {
            return hitResult != null && this.emptyContents(arg, level, hitResult.m_82425_().m_121945_(hitResult.m_82434_()), null, container);
        }
        if (containedFluidStack.isPresent() && myFluid.getFluidType().isVaporizedOnPlacement(level, pos, (FluidStack)containedFluidStack.get())) {
            myFluid.getFluidType().onVaporize(arg, level, pos, (FluidStack)containedFluidStack.get());
            return true;
        }
        if (blockAt instanceof LiquidBlockContainer && (lc = (LiquidBlockContainer)blockAt).m_6044_((BlockGetter)level, pos, stateAt, myFluid)) {
            lc.m_7361_((LevelAccessor)level, pos, stateAt, (FluidState)myFluid.m_76145_().m_61124_((Property)FiniteFluid.LEVEL, (Comparable)Integer.valueOf(this.capacity)));
            this.m_7718_(arg, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.f_46443_ && canReplaceBlock && !stateAt.m_278721_()) {
            level.m_46961_(pos, true);
        }
        if (!level.m_7731_(pos, newState = (BlockState)myFluid.m_76145_().m_76188_().m_61124_((Property)FlammableLiquidBlock.MISSING_LEVELS, (Comparable)Integer.valueOf(16 - this.capacity)), 11) && !stateAt.m_60819_().m_76170_()) {
            return false;
        }
        this.m_7718_(arg, (LevelAccessor)level, pos);
        return true;
    }
}

