/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.entities.RedMerchantEntity;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public abstract class RedMerchantSpawnerMixin {
    @Shadow
    @Final
    private RandomSource f_35908_;
    @Final
    @Shadow
    private ServerLevelData f_35909_;
    @Unique
    private int supplementaries$redSpawnDelay = 0;

    @Shadow
    protected abstract void m_35917_(ServerLevel var1, WanderingTrader var2, int var3);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(ServerLevel serverLevel, boolean b, boolean b1, CallbackInfoReturnable<Integer> cir) {
        if (this.supplementaries$redSpawnDelay > 0) {
            --this.supplementaries$redSpawnDelay;
        }
    }

    @Inject(method={"spawn"}, at={@At(value="RETURN")})
    public void spawn(ServerLevel world, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player;
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.supplementaries$redSpawnDelay == 0 && (player = world.m_8890_()) != null && this.f_35908_.m_188503_(9) == 0) {
            RedMerchantEntity trader;
            PoiManager poiManager;
            Optional optional;
            BlockPos targetPos;
            BlockPos spawnPos;
            BlockPos blockpos = player.m_20183_();
            double mult = RedMerchantSpawnerMixin.supplementaries$getRedMerchantSpawnMultiplier();
            if (mult != 0.0 && (double)this.supplementaries$calculateNormalizeDifficulty(world, blockpos) * mult > (double)(this.f_35908_.m_188501_() * 90.0f) && (spawnPos = this.m_35928_((LevelReader)world, targetPos = (optional = (poiManager = world.m_8904_()).m_27186_(h -> h.m_203565_(PoiTypes.f_218061_), pos -> true, blockpos, 48, PoiManager.Occupancy.ANY)).orElse(blockpos), 48)) != null && this.m_35925_((BlockGetter)world, spawnPos) && !world.m_204166_(spawnPos).m_203565_(Biomes.f_48173_) && (trader = (RedMerchantEntity)ModEntities.RED_MERCHANT.get().m_262496_(world, spawnPos, MobSpawnType.EVENT)) != null) {
                this.f_35909_.m_8115_(trader.m_20148_());
                int lifetime = 25000;
                trader.setDespawnDelay(lifetime);
                trader.setWanderTarget(targetPos);
                trader.m_21446_(targetPos, 16);
                this.supplementaries$redSpawnDelay = lifetime;
            }
        }
    }

    @Unique
    private static double supplementaries$getRedMerchantSpawnMultiplier() {
        return CommonConfigs.getRedMerchantSpawnMultiplier();
    }

    @Unique
    private float supplementaries$calculateNormalizeDifficulty(ServerLevel world, BlockPos pos) {
        float dragon = 1.0f;
        EndDragonFight.Data dragonData = world.m_7654_().m_129910_().m_6564_();
        if (dragonData.f_289711_()) {
            dragon = 1.25f;
        }
        long i = 0L;
        float f = 0.0f;
        if (world.m_46805_(pos)) {
            f = world.m_46940_();
            i = world.m_46745_(pos).m_6319_();
        }
        DifficultyInstance instance = new DifficultyInstance(Difficulty.NORMAL, world.m_46468_(), i, f);
        float diff = instance.m_19056_();
        diff = (float)((double)diff - 1.5);
        diff *= 4.0f;
        float scale = switch (world.m_46791_()) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 1.0f;
            case Difficulty.EASY -> 1.25f;
            case Difficulty.NORMAL -> 1.5f;
            case Difficulty.HARD -> 1.75f;
        };
        diff *= scale;
        diff *= dragon;
        if (MiscUtils.FESTIVITY.isChristmas()) {
            diff *= 15.0f;
        }
        return diff;
    }

    @Shadow
    protected abstract boolean m_35925_(BlockGetter var1, BlockPos var2);

    @Shadow
    protected abstract BlockPos m_35928_(LevelReader var1, BlockPos var2, int var3);
}

