/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public final class IoUtil {
    private static final int DEFAULT_EXTRACT_FLAGS = 1;

    private IoUtil() {
    }

    public static List<ItemStack> extractFromInternalItemStorage(List<ItemStack> list, IStorageDisk<ItemStack> storage, Action action) {
        ArrayList<ItemStack> extracted = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            ItemStack result = storage.extract(stack, stack.m_41613_(), 1, action);
            if (result.m_41619_() || result.m_41613_() != stack.m_41613_()) {
                if (action == Action.PERFORM) {
                    throw new IllegalStateException("The internal crafting inventory reported that " + stack + " was available but we got " + result);
                }
                return null;
            }
            extracted.add(result);
        }
        return extracted;
    }

    public static List<FluidStack> extractFromInternalFluidStorage(List<FluidStack> list, IStorageDisk<FluidStack> storage, Action action) {
        ArrayList<FluidStack> extracted = new ArrayList<FluidStack>();
        for (FluidStack stack : list) {
            FluidStack result = storage.extract(stack, stack.getAmount(), 1, action);
            if (result.isEmpty() || result.getAmount() != stack.getAmount()) {
                if (action == Action.PERFORM) {
                    throw new IllegalStateException("The internal crafting inventory reported that " + stack + " was available but we got " + result);
                }
                return null;
            }
            extracted.add(result);
        }
        return extracted;
    }

    public static void extractItemsFromNetwork(IStackList<ItemStack> toExtractInitial, INetwork network, IStorageDisk<ItemStack> internalStorage) {
        if (toExtractInitial.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        for (StackListEntry<ItemStack> toExtract : toExtractInitial.getStacks()) {
            ItemStack result = network.extractItem(toExtract.getStack(), toExtract.getStack().m_41613_(), Action.PERFORM);
            if (result.m_41619_()) continue;
            internalStorage.insert(toExtract.getStack(), result.m_41613_(), Action.PERFORM);
            toRemove.add(result);
        }
        for (ItemStack stack : toRemove) {
            toExtractInitial.remove(stack);
        }
        if (!toRemove.isEmpty()) {
            network.getCraftingManager().onTaskChanged();
        }
    }

    public static void extractFluidsFromNetwork(IStackList<FluidStack> toExtractInitial, INetwork network, IStorageDisk<FluidStack> internalStorage) {
        if (toExtractInitial.isEmpty()) {
            return;
        }
        ArrayList<FluidStack> toRemove = new ArrayList<FluidStack>();
        for (StackListEntry<FluidStack> toExtract : toExtractInitial.getStacks()) {
            FluidStack result = network.extractFluid(toExtract.getStack(), toExtract.getStack().getAmount(), Action.PERFORM);
            if (result.isEmpty()) continue;
            internalStorage.insert(result, result.getAmount(), Action.PERFORM);
            toRemove.add(result);
        }
        for (FluidStack stack : toRemove) {
            toExtractInitial.remove(stack);
        }
        if (!toRemove.isEmpty()) {
            network.getCraftingManager().onTaskChanged();
        }
    }
}

