/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class SerializationUtil {
    private static final String NBT_PATTERN_STACK = "Stack";
    private static final String NBT_PATTERN_CONTAINER_POS = "ContainerPos";

    private SerializationUtil() {
    }

    public static ListTag writeItemStackList(IStackList<ItemStack> stacks) {
        ListTag list = new ListTag();
        for (StackListEntry<ItemStack> entry : stacks.getStacks()) {
            list.add((Object)StackUtils.serializeStackToNbt(entry.getStack()));
        }
        return list;
    }

    public static IStackList<ItemStack> readItemStackList(ListTag list) throws CraftingTaskReadException {
        IStackList<ItemStack> stacks = API.instance().createItemStackList();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(list.m_128728_(i));
            if (stack.m_41619_()) {
                throw new CraftingTaskReadException("Empty stack!");
            }
            stacks.add(stack);
        }
        return stacks;
    }

    public static ListTag writeFluidStackList(IStackList<FluidStack> stacks) {
        ListTag list = new ListTag();
        for (StackListEntry<FluidStack> entry : stacks.getStacks()) {
            list.add((Object)entry.getStack().writeToNBT(new CompoundTag()));
        }
        return list;
    }

    public static IStackList<FluidStack> readFluidStackList(ListTag list) throws CraftingTaskReadException {
        IStackList<FluidStack> stacks = API.instance().createFluidStackList();
        for (int i = 0; i < list.size(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)list.m_128728_(i));
            if (stack.isEmpty()) {
                throw new CraftingTaskReadException("Empty stack!");
            }
            stacks.add(stack);
        }
        return stacks;
    }

    public static CompoundTag writePatternToNbt(ICraftingPattern pattern) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBT_PATTERN_STACK, (Tag)pattern.getStack().serializeNBT());
        tag.m_128356_(NBT_PATTERN_CONTAINER_POS, pattern.getContainer().getPosition().m_121878_());
        return tag;
    }

    public static ICraftingPattern readPatternFromNbt(CompoundTag tag, Level level) throws CraftingTaskReadException {
        BlockPos containerPos = BlockPos.m_122022_((long)tag.m_128454_(NBT_PATTERN_CONTAINER_POS));
        INetworkNode node = API.instance().getNetworkNodeManager((ServerLevel)level).getNode(containerPos);
        if (node instanceof ICraftingPatternContainer) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(NBT_PATTERN_STACK));
            if (stack.m_41720_() instanceof ICraftingPatternProvider) {
                return ((ICraftingPatternProvider)stack.m_41720_()).create(level, stack, (ICraftingPatternContainer)((Object)node));
            }
            throw new CraftingTaskReadException("Pattern stack is not a crafting pattern provider");
        }
        throw new CraftingTaskReadException("Crafting pattern container doesn't exist anymore");
    }
}

