/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk.factory;

import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskFactory;
import com.refinedmods.refinedstorage.apiimpl.storage.ItemStorageType;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.ItemStorageDisk;
import com.refinedmods.refinedstorage.item.StorageDiskItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStorageDiskFactory
implements IStorageDiskFactory<ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "item");

    @Override
    public IStorageDisk<ItemStack> createFromNbt(ServerLevel level, CompoundTag tag) {
        ItemStorageDisk disk = new ItemStorageDisk(level, tag.m_128451_("Capacity"), tag.m_128441_("Owner") ? tag.m_128342_("Owner") : null);
        ListTag list = tag.m_128437_("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(list.m_128728_(i));
            if (stack.m_41619_()) continue;
            disk.getRawStacks().put((Object)stack.m_41720_(), (Object)stack);
        }
        disk.updateItemCount();
        return disk;
    }

    @Override
    public ItemStack createDiskItem(IStorageDisk<ItemStack> disk, UUID id) {
        StorageDiskItem item = switch (disk.getCapacity()) {
            case 1000 -> (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.ONE_K).get();
            case 4000 -> (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.FOUR_K).get();
            case 16000 -> (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.SIXTEEN_K).get();
            case 64000 -> (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.SIXTY_FOUR_K).get();
            default -> (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.CREATIVE).get();
        };
        ItemStack stack = new ItemStack((ItemLike)item);
        item.setId(stack, id);
        return stack;
    }

    @Override
    public IStorageDisk<ItemStack> create(ServerLevel level, int capacity, @Nullable UUID owner) {
        return new ItemStorageDisk(level, capacity, owner);
    }
}

