/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class GridCraftingStartRequestMessage {
    private final UUID id;
    private final int quantity;
    private final boolean fluids;

    public GridCraftingStartRequestMessage(UUID id, int quantity, boolean fluids) {
        this.id = id;
        this.quantity = quantity;
        this.fluids = fluids;
    }

    public static GridCraftingStartRequestMessage decode(FriendlyByteBuf buf) {
        return new GridCraftingStartRequestMessage(buf.m_130259_(), buf.readInt(), buf.readBoolean());
    }

    public static void encode(GridCraftingStartRequestMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.id);
        buf.writeInt(message.quantity);
        buf.writeBoolean(message.fluids);
    }

    public static void handle(GridCraftingStartRequestMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                AbstractContainerMenu container = player.f_36096_;
                if (container instanceof GridContainerMenu) {
                    IGrid grid = ((GridContainerMenu)container).getGrid();
                    if (message.fluids) {
                        if (grid.getFluidHandler() != null) {
                            grid.getFluidHandler().onCraftingRequested(player, message.id, message.quantity);
                        }
                    } else if (grid.getItemHandler() != null) {
                        grid.getItemHandler().onCraftingRequested(player, message.id, message.quantity);
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

