/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.block.PortableGridBlock;
import com.refinedmods.refinedstorage.blockentity.grid.portable.PortableGrid;
import com.refinedmods.refinedstorage.blockentity.grid.portable.PortableGridDiskState;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.render.model.baked.PortableGridItemBakedModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;

public class PortableGridBakedModel
extends BakedModelWrapper<BakedModel> {
    private final Function<Direction, BakedModel> baseConnectedModelBakery;
    private final Function<Direction, BakedModel> baseDisconnectedModelBakery;
    private final Function<Direction, BakedModel> diskModelBakery;
    private final Function<Direction, BakedModel> diskNearCapacityModelBakery;
    private final Function<Direction, BakedModel> diskFullModelBakery;
    private final Function<Direction, BakedModel> diskDisconnectedModelBakery;
    private final RenderTypeGroup renderTypes;
    private final CustomItemOverrideList itemOverrideList = new CustomItemOverrideList();
    private final LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(@Nonnull CacheKey key) {
            Direction direction = (Direction)key.state.m_61143_((Property)((PortableGridBlock)((Object)RSBlocks.PORTABLE_GRID.get())).getDirection().getProperty());
            boolean active = (Boolean)key.state.m_61143_((Property)PortableGridBlock.ACTIVE);
            PortableGridDiskState diskState = (PortableGridDiskState)((Object)key.state.m_61143_(PortableGridBlock.DISK_STATE));
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>((active ? PortableGridBakedModel.this.baseConnectedModelBakery : PortableGridBakedModel.this.baseDisconnectedModelBakery).apply(direction).m_213637_(key.state, key.side, key.random));
            Function<Direction, BakedModel> diskModel = PortableGridBakedModel.this.getDiskModelBakery(diskState);
            if (diskModel != null) {
                quads.addAll(diskModel.apply(direction).m_213637_(key.state, key.side, key.random));
            }
            return quads;
        }
    });

    public PortableGridBakedModel(BakedModel baseModel, Function<Direction, BakedModel> baseConnectedModelBakery, Function<Direction, BakedModel> baseDisconnectedModelBakery, Function<Direction, BakedModel> diskModelBakery, Function<Direction, BakedModel> diskNearCapacityModelBakery, Function<Direction, BakedModel> diskFullModelBakery, Function<Direction, BakedModel> diskDisconnectedModelBakery, RenderTypeGroup renderTypes) {
        super(baseModel);
        this.baseConnectedModelBakery = baseConnectedModelBakery;
        this.baseDisconnectedModelBakery = baseDisconnectedModelBakery;
        this.diskModelBakery = diskModelBakery;
        this.diskNearCapacityModelBakery = diskNearCapacityModelBakery;
        this.diskFullModelBakery = diskFullModelBakery;
        this.diskDisconnectedModelBakery = diskDisconnectedModelBakery;
        this.renderTypes = renderTypes;
    }

    @Nullable
    private Function<Direction, BakedModel> getDiskModelBakery(PortableGridDiskState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case PortableGridDiskState.NORMAL -> this.diskModelBakery;
            case PortableGridDiskState.NEAR_CAPACITY -> this.diskNearCapacityModelBakery;
            case PortableGridDiskState.FULL -> this.diskFullModelBakery;
            case PortableGridDiskState.DISCONNECTED -> this.diskDisconnectedModelBakery;
            case PortableGridDiskState.NONE -> null;
        };
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.renderTypes.block()});
    }

    public ItemOverrides m_7343_() {
        return this.itemOverrideList;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        if (state != null) {
            return (List)this.cache.getUnchecked((Object)new CacheKey(state, side, rand));
        }
        return super.getQuads(state, side, rand, extraData, renderType);
    }

    private class CustomItemOverrideList
    extends ItemOverrides {
        private CustomItemOverrideList() {
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p) {
            BakedModel diskModel;
            PortableGrid portableGrid = new PortableGrid(null, stack, new PlayerSlot(-1));
            Function<Direction, BakedModel> diskModelBakery = PortableGridBakedModel.this.getDiskModelBakery(portableGrid.getDiskState());
            BakedModel bakedModel = diskModel = diskModelBakery == null ? null : diskModelBakery.apply(Direction.NORTH);
            if (portableGrid.isGridActive()) {
                return new PortableGridItemBakedModel(PortableGridBakedModel.this.baseConnectedModelBakery.apply(Direction.NORTH), diskModel);
            }
            return new PortableGridItemBakedModel(PortableGridBakedModel.this.baseDisconnectedModelBakery.apply(Direction.NORTH), diskModel);
        }
    }

    private static class CacheKey {
        private final BlockState state;
        private final Direction side;
        private final RandomSource random;

        public CacheKey(BlockState state, Direction side, RandomSource random) {
            this.state = state;
            this.side = side;
            this.random = random;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.state.equals(cacheKey.state) && this.side == cacheKey.side && this.random.equals(cacheKey.random);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.side, this.random);
        }
    }
}

