/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.endermanoverhaul.common.ModUtils;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;

public class EndEnderman
extends BaseEnderman {
    private static final EntityDataAccessor<Integer> DATA_BITING_TICKS = SynchedEntityData.m_135353_(EndEnderman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EndEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 8;
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.38).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnEndEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return BaseEnderman.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "bite_controller", 5, state -> {
            if ((Integer)this.f_19804_.m_135370_(DATA_BITING_TICKS) <= 0) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.BITE);
            return PlayState.CONTINUE;
        })});
    }

    @Override
    public void m_8119_() {
        if ((Integer)this.f_19804_.m_135370_(DATA_BITING_TICKS) > 0) {
            this.f_19804_.m_135381_(DATA_BITING_TICKS, (Object)((Integer)this.f_19804_.m_135370_(DATA_BITING_TICKS) - 1));
        }
        super.m_8119_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BITING_TICKS, (Object)0);
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    public boolean canShake() {
        return false;
    }

    @Override
    public boolean playArmSwingAnimWhenAttacking() {
        return false;
    }

    @Override
    public boolean isProvokedByEyeContact() {
        return false;
    }

    @Override
    public boolean isAlwaysHostile() {
        return true;
    }

    @Override
    public boolean canTeleport() {
        return false;
    }

    @Override
    public double getVisionRange() {
        return 24.0;
    }

    @Override
    public boolean canPickupBlocks() {
        return false;
    }

    @Override
    public boolean speedUpWhenAngry() {
        return false;
    }

    @Override
    public boolean m_7327_(@NotNull Entity target) {
        if (super.m_7327_(target)) {
            this.m_5496_(SoundEvents.f_12228_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
            this.f_19804_.m_135381_(DATA_BITING_TICKS, (Object)7);
            if (target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                if (this.f_19796_.m_188501_() < EndermanOverhaulConfig.endEndermanTeleportChance) {
                    ModUtils.teleportTarget(this.m_9236_(), entity, 24);
                }
            }
            return true;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_HURT.get();
    }
}

