/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.task;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public class TaskRequirement {
    public static final Codec<TaskRequirement> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Requirement.CODEC.listOf().fieldOf("requirements").forGetter(i -> i.requirements.values().stream().flatMap(Collection::stream).sorted(Comparator.comparing(Requirement::id)).toList())).apply((Applicative)inst, TaskRequirement::new));
    private final Map<Type, List<Requirement<?>>> requirements;
    private final int size;
    private final boolean hasStatBasedReq;

    public TaskRequirement(@NotNull Map<Type, List<Requirement<?>>> requirements) {
        this.requirements = requirements;
        this.size = requirements.values().stream().mapToInt(List::size).sum();
        this.hasStatBasedReq = requirements.keySet().stream().anyMatch(Type::isStatBased);
    }

    public TaskRequirement(@NotNull Collection<Requirement<?>> requirements) {
        this.requirements = requirements.stream().collect(Collectors.toMap(Requirement::getType, xva$0 -> Lists.newArrayList((Object[])new Requirement[]{xva$0}), (a, b) -> {
            a.addAll(b);
            return a;
        }));
        this.size = this.requirements.values().stream().mapToInt(List::size).sum();
        this.hasStatBasedReq = this.requirements.keySet().stream().anyMatch(Type::isStatBased);
    }

    @NotNull
    public List<Requirement<?>> getAll() {
        return this.requirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isHasStatBasedReq() {
        return this.hasStatBasedReq;
    }

    public void removeRequirement(IFactionPlayer<?> player) {
        for (Type type : this.requirements.keySet()) {
            for (Requirement<?> requirement : this.requirements.get((Object)type)) {
                requirement.removeRequirement(player);
            }
        }
    }

    public Map<Type, List<Requirement<?>>> requirements() {
        return this.requirements;
    }

    public int size() {
        return this.size;
    }

    public static enum Type implements StringRepresentable
    {
        STATS(true, "gui.vampirism.taskmaster.stat_req"),
        ITEMS(false, "gui.vampirism.taskmaster.item_req"),
        ENTITY(true, "gui.vampirism.taskmaster.entity_req"),
        ENTITY_TAG(true, "gui.vampirism.taskmaster.entity_tag_req"),
        BOOLEAN(false, "gui.vampirism.taskmaster.bool_req");

        public static final Codec<Type> CODEC;
        private final boolean statBased;
        private final String translationKey;

        private Type(boolean statBased, String translationKey) {
            this.statBased = statBased;
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public boolean isStatBased() {
            return this.statBased;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
        }
    }

    public static interface Requirement<T> {
        public static final Codec<Requirement<?>> CODEC = ExtraCodecs.m_184415_(() -> VampirismRegistries.TASK_REQUIREMENTS.get().getCodec()).dispatch(Requirement::codec, Function.identity());

        default public int getAmount(IFactionPlayer<?> player) {
            return 1;
        }

        @NotNull
        public ResourceLocation id();

        @NotNull
        public T getStat(IFactionPlayer<?> var1);

        @NotNull
        default public Type getType() {
            return Type.BOOLEAN;
        }

        default public void removeRequirement(IFactionPlayer<?> player) {
        }

        public Codec<? extends Requirement<?>> codec();

        public Component description();
    }
}

