/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.screens.radialmenu.IRadialMenuSlot;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.RadialMenu;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.RadialMenuSlot;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.client.ClientConfigHelper;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.screens.SelectActionRadialScreen;
import de.teamlapen.vampirism.client.gui.screens.radial.DualSwitchingRadialMenu;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.ServerboundSelectMinionTaskPacket;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SelectMinionTaskRadialScreen
extends DualSwitchingRadialMenu<Entry> {
    public static Map<ResourceLocation, Entry> CUSTOM_ENTRIES = Stream.of(new Entry(new ResourceLocation("vampirism", "call_single"), (Component)Component.m_237115_((String)"text.vampirism.minion.call_single"), new ResourceLocation("vampirism", "textures/minion_tasks/recall_single.png"), SelectMinionTaskRadialScreen::callSingle), new Entry(new ResourceLocation("vampirism", "call_all"), (Component)Component.m_237115_((String)"text.vampirism.minion.call_all"), new ResourceLocation("vampirism", "textures/minion_tasks/recall.png"), SelectMinionTaskRadialScreen::callAll), new Entry(new ResourceLocation("vampirism", "respawn"), (Component)Component.m_237115_((String)"text.vampirism.minion.respawn"), new ResourceLocation("vampirism", "textures/minion_tasks/respawn.png"), SelectMinionTaskRadialScreen::callRespawn)).collect(Collectors.toMap(e -> e.id, e -> e));

    private SelectMinionTaskRadialScreen(Collection<Entry> entries, KeyMapping keyMapping) {
        super(SelectMinionTaskRadialScreen.getRadialMenu(entries), keyMapping, SelectActionRadialScreen::show);
    }

    public static void show() {
        SelectMinionTaskRadialScreen.show(ModKeys.MINION);
    }

    public static void show(KeyMapping mapping) {
        FactionPlayerHandler.getOpt((Player)Minecraft.m_91087_().f_91074_).filter(p -> p.getLordLevel() > 0).ifPresent(p -> {
            List<Entry> tasks = SelectMinionTaskRadialScreen.getTasks(p);
            if (tasks.isEmpty()) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"text.vampirism.no_minion_tasks"), true);
                Minecraft.m_91087_().m_91152_(null);
            } else {
                Minecraft.m_91087_().m_91152_((Screen)new SelectMinionTaskRadialScreen(tasks, mapping));
            }
        });
    }

    private static List<Entry> getTasks(IFactionPlayerHandler playerHandler) {
        if (playerHandler.getLordLevel() == 0) {
            return List.of();
        }
        return playerHandler.getCurrentFactionPlayer().map(player -> ClientConfigHelper.getMinionTaskOrder(playerHandler.getCurrentFaction()).stream().filter(entry -> Optional.ofNullable(entry.getTask()).map(s -> s.isAvailable((IPlayableFaction<?>)player.getFaction(), playerHandler)).orElse(true)).collect(Collectors.toList())).orElseGet(List::of);
    }

    private static RadialMenu<Entry> getRadialMenu(Collection<Entry> playerHandler) {
        List parts = playerHandler.stream().map(entry -> new RadialMenuSlot<Entry>(entry.text, (Entry)entry)).toList();
        return new RadialMenu<Entry>(i -> ((Entry)((IRadialMenuSlot)parts.get((int)i)).primarySlotIcon()).onSelected.run(), parts, SelectMinionTaskRadialScreen::drawActionPart, 0);
    }

    private static void drawActionPart(Entry t, GuiGraphics graphics, int posX, int posY, int size, boolean transparent) {
        graphics.m_280398_(t.getIconLoc(), posX, posY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static void callAll() {
        VampirismMod.dispatcher.sendToServer(new ServerboundSelectMinionTaskPacket(-1, ServerboundSelectMinionTaskPacket.RECALL));
    }

    private static void callRespawn() {
        VampirismMod.dispatcher.sendToServer(new ServerboundSelectMinionTaskPacket(-1, ServerboundSelectMinionTaskPacket.RESPAWN));
    }

    private static void callSingle() {
        VampirismMod.dispatcher.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Type.SHOW_MINION_CALL_SELECTION));
    }

    private static void sendTask(IMinionTask<?, ?> task) {
        VampirismMod.dispatcher.sendToServer(new ServerboundSelectMinionTaskPacket(-1, RegUtil.id(task)));
    }

    public static class Entry {
        private final ResourceLocation id;
        private final Component text;
        private final ResourceLocation loc;
        private final Runnable onSelected;
        private final IMinionTask<?, ?> task;

        public Entry(@NotNull IMinionTask<?, ?> task) {
            this(RegUtil.id(task), task.getName(), new ResourceLocation(RegUtil.id(task).m_135827_(), "textures/minion_tasks/" + RegUtil.id(task).m_135815_() + ".png"), () -> SelectMinionTaskRadialScreen.sendTask(task), task);
        }

        public Entry(@NotNull ResourceLocation id, @NotNull Component text, @NotNull ResourceLocation icon, @NotNull Runnable onSelected, @Nullable IMinionTask<?, ?> task) {
            this.id = id;
            this.text = text;
            this.loc = icon;
            this.onSelected = onSelected;
            this.task = task;
        }

        public Entry(@NotNull ResourceLocation id, @NotNull Component text, @NotNull ResourceLocation icon, @NotNull Runnable onSelected) {
            this(id, text, icon, onSelected, null);
        }

        @NotNull
        public ResourceLocation getIconLoc() {
            return this.loc;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }

        @NotNull
        public Component getText() {
            return this.text;
        }

        @Nullable
        public IMinionTask<?, ?> getTask() {
            return this.task;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                Entry other = (Entry)obj;
                return this.id.equals((Object)other.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

