/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.command.arguments.SkillArgument;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.util.RegUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkillCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_FACTION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.vampirism.test.skill.noinfaction"));

    public static ArgumentBuilder<CommandSourceStack, ?> registerTest() {
        return SkillCommand.create(Commands.m_82127_((String)"skill"));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return SkillCommand.create(Commands.m_82127_((String)"skills"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> create(@NotNull ArgumentBuilder<CommandSourceStack, ?> builder) {
        return builder.requires(context -> context.m_6761_(3)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)SkillArgument.skills()).executes(context -> SkillCommand.skill((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "type"), false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> SkillCommand.skill((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "type"), false))).then(Commands.m_82127_((String)"force").executes(context -> SkillCommand.skill((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "type"), true))))).then(Commands.m_82127_((String)"force").executes(context -> SkillCommand.skill((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "type"), true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"disableall").executes(context -> SkillCommand.disableall((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> SkillCommand.disableall((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"enableall").executes(context -> SkillCommand.enableAll((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> SkillCommand.enableAll((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
    }

    private static int disableall(@NotNull CommandSourceStack commandSource, @NotNull ServerPlayer asPlayer) throws CommandSyntaxException {
        IFactionPlayer<?> factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer((Player)asPlayer).orElseThrow(() -> ((SimpleCommandExceptionType)NO_FACTION).create());
        factionPlayer.getSkillHandler().resetSkills();
        commandSource.m_288197_(() -> Component.m_237115_((String)"command.vampirism.test.skill.all_locked"), false);
        return 0;
    }

    private static int enableAll(@NotNull CommandSourceStack commandSource, @NotNull ServerPlayer asPlayer) throws CommandSyntaxException {
        FactionPlayerHandler playerHandler = (FactionPlayerHandler)FactionPlayerHandler.getOpt((Player)asPlayer).orElseThrow(() -> ((SimpleCommandExceptionType)NO_FACTION).create());
        IFactionPlayer<?> factionPlayer = playerHandler.getCurrentFactionPlayer().orElseThrow(() -> ((SimpleCommandExceptionType)NO_FACTION).create());
        ISkillHandler<?> skillHandler = factionPlayer.getSkillHandler();
        for (ISkill skill : RegUtil.values(ModRegistries.SKILLS)) {
            if (!skill.getType().isUnlocked(playerHandler) || skill.getFaction().map(f -> f != factionPlayer.getFaction()).orElse(false).booleanValue()) continue;
            skillHandler.enableSkill(skill);
        }
        commandSource.m_288197_(() -> Component.m_237115_((String)"command.vampirism.test.skill.all_unlocked"), false);
        return 0;
    }

    private static int skill(@NotNull CommandSourceStack commandSource, @NotNull ServerPlayer asPlayer, @NotNull ISkill skill, boolean force) throws CommandSyntaxException {
        IFactionPlayer<?> factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer((Player)asPlayer).orElseThrow(() -> ((SimpleCommandExceptionType)NO_FACTION).create());
        if (factionPlayer.getSkillHandler().isSkillEnabled(skill)) {
            factionPlayer.getSkillHandler().disableSkill(skill);
            commandSource.m_288197_(() -> Component.m_237115_((String)"command.vampirism.test.skill.disabled"), false);
            return 0;
        }
        ISkillHandler.Result result = factionPlayer.getSkillHandler().canSkillBeEnabled(skill);
        if (force) {
            result = ISkillHandler.Result.OK;
        }
        switch (result) {
            case OK: {
                factionPlayer.getSkillHandler().enableSkill(skill);
                commandSource.m_288197_(() -> Component.m_237110_((String)"command.vampirism.test.skill.enabled", (Object[])new Object[]{String.valueOf(RegUtil.id(skill)) + " (" + skill.getName().getString() + ")"}), false);
                break;
            }
            case ALREADY_ENABLED: {
                commandSource.m_288197_(() -> Component.m_237110_((String)"command.vampirism.test.skill.alreadyenabled", (Object[])new Object[]{skill.getName()}), false);
                break;
            }
            case PARENT_NOT_ENABLED: {
                ISkill<?>[] skills = factionPlayer.getSkillHandler().getParentSkills(skill);
                if (skills == null || skills.length == 0) {
                    return 0;
                }
                if (skills.length == 1) {
                    commandSource.m_81352_((Component)Component.m_237110_((String)"command.vampirism.test.skill.parent", (Object[])new Object[]{RegUtil.id(skills[0])}));
                    break;
                }
                commandSource.m_81352_((Component)Component.m_237110_((String)"command.vampirism.test.skill.parents", (Object[])new Object[]{RegUtil.id(skills[0]), RegUtil.id(skills[1])}));
                break;
            }
            case NO_POINTS: {
                commandSource.m_81352_((Component)Component.m_237115_((String)"command.vampirism.test.skill.nopoints"));
                break;
            }
            case OTHER_NODE_SKILL: {
                commandSource.m_81352_((Component)Component.m_237115_((String)"command.vampirism.test.skill.othernode"));
                break;
            }
            case NOT_FOUND: {
                commandSource.m_81352_((Component)Component.m_237115_((String)"command.vampirism.test.skill.otherfaction"));
                break;
            }
            case LOCKED_BY_OTHER_NODE: {
                commandSource.m_81352_((Component)Component.m_237115_((String)"command.vampirism.test.skill.locked"));
                break;
            }
            case LOCKED_BY_PLAYER_STATE: {
                commandSource.m_81352_((Component)Component.m_237115_((String)"command.vampirism.test.skill.locked_player_state"));
            }
        }
        return 0;
    }
}

