/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ModEntitySelectors {
    private static final String FACTION = "vampirism:faction";
    private static final String LEVEL = "vampirism:level";
    private static final String MIN_LEVEL = "vampirism:minLevel";
    private static final String MAX_LEVEL = "vampirism:maxLevel";
    private static final DynamicCommandExceptionType FACTION_NOT_FOUND = new DynamicCommandExceptionType(p_208726_0_ -> Component.m_237110_((String)"vampirism.argument.entity.options.faction.not_found", (Object[])new Object[]{p_208726_0_}));

    public static void registerSelectors() {
        EntitySelectorOptions.m_121453_((String)FACTION, parser -> {
            IFaction<?>[] factions;
            boolean invert = parser.m_121330_();
            ResourceLocation factionID = new ResourceLocation(parser.m_121346_().readString());
            for (IFaction<?> f : factions = VampirismAPI.factionRegistry().getFactions()) {
                if (!f.getID().equals((Object)factionID)) continue;
                parser.m_121272_(input -> {
                    if (input instanceof IFactionEntity) {
                        boolean flag1 = f.equals(((IFactionEntity)input).getFaction());
                        return invert != flag1;
                    }
                    if (f instanceof IPlayableFaction && input instanceof Player) {
                        boolean flag1 = FactionPlayerHandler.getOpt((Player)input).map(h -> h.isInFaction(f)).orElse(false);
                        return invert != flag1;
                    }
                    return invert;
                });
                return;
            }
            throw FACTION_NOT_FOUND.createWithContext((ImmutableStringReader)parser.m_121346_(), (Object)factionID);
        }, parser -> true, (Component)Component.m_237115_((String)"vampirism.argument.entity.options.faction.desc"));
        EntitySelectorOptions.m_121453_((String)LEVEL, parser -> {
            StringReader reader = parser.m_121346_();
            MinMaxBounds.Ints bound = MinMaxBounds.Ints.m_55375_((StringReader)reader);
            if (bound.m_55305_() != null && (Integer)bound.m_55305_() < 0 || bound.m_55326_() != null && (Integer)bound.m_55326_() < 0) {
                throw EntitySelectorOptions.f_121387_.createWithContext((ImmutableStringReader)reader);
            }
            parser.m_121272_(input -> {
                if (input instanceof Player) {
                    int level = FactionPlayerHandler.getOpt((Player)input).map(FactionPlayerHandler::getCurrentLevel).orElse(0);
                    return !(bound.m_55305_() != null && (Integer)bound.m_55305_() > level || bound.m_55326_() != null && (Integer)bound.m_55326_() < level);
                }
                return false;
            });
        }, parser -> true, (Component)Component.m_237115_((String)"vampirism.argument.entity.options.level.desc"));
    }
}

