/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModSounds {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"vampirism");
    public static final RegistryObject<SoundEvent> ENTITY_VAMPIRE_SCREAM = ModSounds.create("entity.vampire_scream");
    public static final RegistryObject<SoundEvent> VAMPIRE_BITE = ModSounds.create("entity.vampire_bite");
    public static final RegistryObject<SoundEvent> AMBIENT_BLOOD_DRIPPING = ModSounds.create("ambient.blood_dripping");
    public static final RegistryObject<SoundEvent> COFFIN_LID = ModSounds.create("coffin_lid");
    public static final RegistryObject<SoundEvent> BAT_SWARM = ModSounds.create("entity.bat_swarm");
    public static final RegistryObject<SoundEvent> BOILING = ModSounds.create("block.boiling");
    public static final RegistryObject<SoundEvent> GRINDER = ModSounds.create("block.grinder");
    public static final RegistryObject<SoundEvent> TASK_COMPLETE = ModSounds.create("task_complete");
    public static final RegistryObject<SoundEvent> VAMPIRE_FEEDING = ModSounds.create("entity.vampire_feeding");
    public static final RegistryObject<SoundEvent> BLESSING_MUSIC = ModSounds.create("block.blessing_music");
    public static final RegistryObject<SoundEvent> BLOOD_PROJECTILE_HIT = ModSounds.create("fx.blood_projectile_hit");
    public static final RegistryObject<SoundEvent> WEAPON_TABLE_CRAFTING = ModSounds.create("block.weapon_table_crafting");
    public static final RegistryObject<SoundEvent> STAKE = ModSounds.create("fx.stake");
    public static final RegistryObject<SoundEvent> TELEPORT_AWAY = ModSounds.create("fx.teleport_away");
    public static final RegistryObject<SoundEvent> TELEPORT_HERE = ModSounds.create("fx.teleport_here");
    public static final RegistryObject<SoundEvent> FREEZE = ModSounds.create("fx.freeze");
    public static final RegistryObject<SoundEvent> POTION_TABLE_CRAFTING = ModSounds.create("block.potion_table_crafting");
    public static final RegistryObject<SoundEvent> MOTHER_DEATH = ModSounds.create("fx.mother_death");
    public static final RegistryObject<SoundEvent> MOTHER_AMBIENT = ModSounds.create("ambient.mother");
    public static final RegistryObject<SoundEvent> VAMPIRE_FOREST_AMBIENT = ModSounds.create("ambient.forest");
    public static final RegistryObject<SoundEvent> GHOST_AMBIENT = ModSounds.create("entity.ghost.ambient");
    public static final RegistryObject<SoundEvent> GHOST_DEATH = ModSounds.create("entity.ghost.death");
    public static final RegistryObject<SoundEvent> GHOST_HURT = ModSounds.create("entity.ghost.hurt");
    public static final RegistryObject<SoundEvent> REMAINS_DEFENDER_AMBIENT = ModSounds.create("entity.remains_defender.ambient");
    public static final RegistryObject<SoundEvent> REMAINS_DEFENDER_DEATH = ModSounds.create("entity.remains_defender.death");
    public static final RegistryObject<SoundEvent> REMAINS_DEFENDER_HURT = ModSounds.create("entity.remains_defender.hit");
    public static final RegistryObject<SoundEvent> REMAINS_DEATH = ModSounds.create("entity.remains.death");
    public static final RegistryObject<SoundEvent> REMAINS_HURT = ModSounds.create("entity.remains.hurt");
    private static final Map<ResourceKey<SoundEvent>, Music> music = new HashMap<ResourceKey<SoundEvent>, Music>();

    static void register(IEventBus bus) {
        SOUND_EVENTS.register(bus);
    }

    private static RegistryObject<SoundEvent> create(@NotNull String soundNameIn) {
        ResourceLocation resourcelocation = new ResourceLocation("vampirism", soundNameIn);
        return SOUND_EVENTS.register(soundNameIn, () -> SoundEvent.m_262824_((ResourceLocation)resourcelocation));
    }

    public static Music getMusic(ResourceKey<SoundEvent> soundEvent) {
        return music.computeIfAbsent(soundEvent, sound -> ForgeRegistries.SOUND_EVENTS.getHolder(sound).map(event -> new Music(event, 0, 0, true)).orElse(Musics.f_11651_));
    }
}

