/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.data.reloadlistener.SundamageReloadListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SundamageProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PackOutput.PathProvider pathProvider;
    private final String modId;

    public SundamageProvider(PackOutput packOutput, String modId) {
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "vampirism");
        this.modId = modId;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput pOutput) {
        Consumer consumer = new Consumer();
        this.registerNoSundamageBiomes(consumer);
        return DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)((JsonElement)SundamageReloadListener.RawFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)consumer.build()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))), (Path)this.pathProvider.m_245731_(new ResourceLocation(this.modId, "no_sun_damage")));
    }

    @NotNull
    public String m_6055_() {
        return "No Sundamage";
    }

    protected void registerNoSundamageBiomes(Consumer consumer) {
        consumer.addBiome(ModTags.Biomes.IS_VAMPIRE_BIOME);
        consumer.addDimension((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223539_);
        consumer.addDimension((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223540_);
    }

    public static class Consumer {
        private final Set<ExtraCodecs.TagOrElementLocation> biomes = Sets.newHashSet();
        private final Set<ExtraCodecs.TagOrElementLocation> dimensions = Sets.newHashSet();
        private final Set<ResourceKey<Level>> levels = Sets.newHashSet();
        private final Set<ResourceKey<Level>> sunDamageLevels = Sets.newHashSet();

        public void addBiome(ResourceLocation biome) {
            this.biomes.add(new ExtraCodecs.TagOrElementLocation(biome, false));
        }

        public void addBiome(ResourceKey<Biome> biome) {
            this.biomes.add(new ExtraCodecs.TagOrElementLocation(biome.m_135782_(), false));
        }

        public void addBiome(TagKey<Biome> biome) {
            this.biomes.add(new ExtraCodecs.TagOrElementLocation(biome.f_203868_(), true));
        }

        public void addDimension(ResourceLocation dimension) {
            this.dimensions.add(new ExtraCodecs.TagOrElementLocation(dimension, false));
        }

        public void addDimension(ResourceKey<DimensionType> dimension) {
            this.dimensions.add(new ExtraCodecs.TagOrElementLocation(dimension.m_135782_(), false));
        }

        public void addDimension(TagKey<DimensionType> dimension) {
            this.dimensions.add(new ExtraCodecs.TagOrElementLocation(dimension.f_203868_(), true));
        }

        public void addLevelWithoutSundamage(ResourceKey<Level> level) {
            this.levels.add(level);
        }

        public void addLevelWithSundamage(ResourceKey<Level> level) {
            this.sunDamageLevels.add(level);
        }

        private SundamageReloadListener.RawFile build() {
            return new SundamageReloadListener.RawFile(false, new ArrayList<ExtraCodecs.TagOrElementLocation>(this.biomes), new ArrayList<ExtraCodecs.TagOrElementLocation>(this.dimensions), new ArrayList<ResourceKey<Level>>(this.levels), new ArrayList<ResourceKey<Level>>(this.sunDamageLevels));
        }
    }
}

