/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.reloadlistener.bloodvalues;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.teamlapen.vampirism.data.reloadlistener.bloodvalues.BloodValueBuilder;
import de.teamlapen.vampirism.data.reloadlistener.bloodvalues.BloodValueFile;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BloodValueReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Consumer<Map<ResourceLocation, Float>> valueConsumer;
    private final String directory;
    private final String name;

    public BloodValueReader(Consumer<Map<ResourceLocation, Float>> valueConsumer, String directory, String name) {
        this.valueConsumer = valueConsumer;
        this.directory = directory;
        this.name = name;
    }

    @NotNull
    public CompletableFuture<Map<String, BloodValueBuilder>> prepare(@NotNull ResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.load(manager), executor);
    }

    @NotNull
    public Map<String, BloodValueBuilder> load(@NotNull ResourceManager manager) {
        HashMap<String, BloodValueBuilder> values = new HashMap<String, BloodValueBuilder>();
        for (Map.Entry entry : manager.m_214160_(this.directory, file -> file.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            String s = resourcelocation.m_135815_();
            ResourceLocation resourceName = new ResourceLocation(resourcelocation.m_135827_(), s.substring(this.directory.length() + 1, s.length() - PATH_SUFFIX_LENGTH));
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        BloodValueFile file2 = (BloodValueFile)BloodValueFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                        values.computeIfAbsent(resourceName.m_135815_(), id -> new BloodValueBuilder()).addFromFile(new BloodValueBuilder.BuilderEntries(file2.values().stream().map(a -> new BloodValueBuilder.Proxy((BloodValueBuilder.Entry)a, resource.m_215506_())).toList(), file2.replace()));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't read {} blood values {} from {}", (Object)this.name, (Object)resourceName, (Object)resource.m_215506_(), (Object)e);
                }
            }
        }
        return values;
    }

    public void load(@NotNull Map<String, BloodValueBuilder> values) {
        this.valueConsumer.accept(values.entrySet().stream().flatMap(a -> ((BloodValueBuilder)a.getValue()).build().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}

