/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class CrossbowArrowEntity
extends AbstractArrow
implements IEntityCrossbowArrow {
    @NotNull
    private ItemStack arrowStack = new ItemStack((ItemLike)ModItems.CROSSBOW_ARROW_NORMAL.get());
    private boolean ignoreHurtTimer = false;

    public CrossbowArrowEntity(@NotNull EntityType<? extends CrossbowArrowEntity> type, @NotNull Level world) {
        super(type, world);
    }

    public CrossbowArrowEntity(Level level, LivingEntity entity, ItemStack stack) {
        super((EntityType)ModEntities.CROSSBOW_ARROW.get(), entity, level);
        this.arrowStack = stack.m_41777_();
        this.arrowStack.m_41764_(1);
    }

    public CrossbowArrowEntity(@NotNull Level worldIn, double x, double y, double z, @NotNull ItemStack arrow) {
        this((EntityType<? extends CrossbowArrowEntity>)((EntityType)ModEntities.CROSSBOW_ARROW.get()), worldIn);
        this.m_6034_(x, y, z);
        this.arrowStack = arrow.m_41777_();
        this.arrowStack.m_41764_(1);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("arrowStack", (Tag)this.arrowStack.m_41739_(new CompoundTag()));
    }

    public CrossbowArrowItem.EnumArrowType getArrowType() {
        return this.arrowStack.m_41720_() instanceof CrossbowArrowItem ? ((CrossbowArrowItem)this.arrowStack.m_41720_()).getType() : CrossbowArrowItem.EnumArrowType.NORMAL;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    public RandomSource getRNG() {
        return this.f_19796_;
    }

    @Override
    public void setIgnoreHurtTimer() {
        this.ignoreHurtTimer = true;
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.arrowStack.deserializeNBT(compound.m_128469_("arrowStack"));
    }

    protected void m_7761_(@NotNull LivingEntity living) {
        super.m_7761_(living);
        Item item = this.arrowStack.m_41720_();
        if (item instanceof IVampirismCrossbowArrow) {
            if (this.ignoreHurtTimer && living.f_19802_ > 0) {
                living.f_19802_ = 0;
            }
            ((IVampirismCrossbowArrow)item).onHitEntity(this.arrowStack, living, this, this.m_19749_());
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.arrowStack;
    }

    protected void m_8060_(@NotNull BlockHitResult blockRayTraceResult) {
        Item item = this.arrowStack.m_41720_();
        if (item instanceof IVampirismCrossbowArrow) {
            ((IVampirismCrossbowArrow)item).onHitBlock(this.arrowStack, blockRayTraceResult.m_82425_(), this, this.m_19749_());
        }
        super.m_8060_(blockRayTraceResult);
    }

    public void setEffectsFromItem(ItemStack p_200887_2_) {
    }
}

