/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.IEntityFollower;
import de.teamlapen.vampirism.entity.IRemainsEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.VulnerableRemainsDummyEntity;
import de.teamlapen.vampirism.entity.ai.goals.DefendLeaderGoal;
import de.teamlapen.vampirism.entity.ai.goals.FindLeaderGoal;
import de.teamlapen.vampirism.entity.ai.goals.NearestTargetGoalModifier;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GhostEntity
extends VampirismEntity
implements IRemainsEntity,
IEntityFollower {
    private static final UUID SPEED_MODIFIER = UUID.fromString("e8c3b0b0-3d6c-11eb-b378-0242ac130002");
    private IEntityLeader leader;

    public GhostEntity(@NotNull EntityType<? extends VampirismEntity> type, @NotNull Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, 0.3).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 1.0);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        GhostPathNavigation navigation = new GhostPathNavigation((Mob)this, pLevel);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.m_269533_(DamageTypeTags.f_268524_) || pSource.m_269533_(ModTags.DamageTypes.MOTHER_RESISTANT_TO) && super.m_6673_(pSource);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GhostMeleeAttackGoal(1.0, true));
        this.f_21345_.m_25352_(3, new FindLeaderGoal<GhostEntity, LivingEntity>(this, arg_0 -> GhostEntity.lambda$registerGoals$0(VulnerableRemainsDummyEntity.class, arg_0)));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.9f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        NearestAttackableTargetGoal goal = new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true, false, true, true, null));
        ((NearestTargetGoalModifier)goal).ignoreLineOfSight();
        this.f_21346_.m_25352_(3, (Goal)goal);
        NearestAttackableTargetGoal<PathfinderMob> goal2 = new NearestAttackableTargetGoal<PathfinderMob>((Mob)this, PathfinderMob.class, 5, false, false, VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, false, true, false, true, null)){

            protected double m_7623_() {
                return super.m_7623_() / 2.0;
            }
        };
        ((NearestTargetGoalModifier)goal2).ignoreLineOfSight();
        this.f_21346_.m_25352_(4, (Goal)goal2);
        this.f_21346_.m_25352_(8, new DefendLeaderGoal<GhostEntity>(this));
    }

    @Override
    public void m_8119_() {
        this.m_20242_(true);
        this.f_19794_ = true;
        this.m_20101_();
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    protected void m_6763_(BlockState pState) {
        if (pState.m_60795_()) {
            AttributeInstance attribute = this.m_21051_(Attributes.f_22280_);
            if (attribute != null && attribute.m_22111_(SPEED_MODIFIER) == null) {
                attribute.m_22118_(new AttributeModifier(SPEED_MODIFIER, "free movement", 0.2, AttributeModifier.Operation.ADDITION));
            }
        } else {
            AttributeInstance attribute = this.m_21051_(Attributes.f_22280_);
            if (attribute != null) {
                attribute.m_22120_(SPEED_MODIFIER);
            }
        }
    }

    @Override
    public boolean isFollowing() {
        return this.leader != null;
    }

    @Override
    public <T extends LivingEntity> T getLeader() {
        return (T)((LivingEntity)this.leader);
    }

    @Override
    public <T extends LivingEntity> void setLeader(T leader) {
        this.leader = (IEntityLeader)leader;
    }

    public float m_21439_(@NotNull BlockPathTypes pNodeType) {
        return 0.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.GHOST_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.GHOST_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.GHOST_HURT.get();
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    private static /* synthetic */ boolean lambda$registerGoals$0(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }

    static class GhostPathNavigation
    extends FlyingPathNavigation {
        public GhostPathNavigation(Mob pMob, Level pLevel) {
            super(pMob, pLevel);
        }

        protected boolean m_183431_(@NotNull Vec3 pPosVec31, @NotNull Vec3 pPosVec32) {
            return true;
        }
    }

    class GhostMeleeAttackGoal
    extends MeleeAttackGoal {
        public GhostMeleeAttackGoal(double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)GhostEntity.this, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return this.f_25540_.m_20205_() * 3.0f * this.f_25540_.m_20205_() * 3.0f + pAttackTarget.m_20205_();
        }
    }
}

