/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiteableEntryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final Map<ResourceLocation, BiteableEntry> biteableEntries = Maps.newHashMap();
    @NotNull
    private final Map<ResourceLocation, BiteableEntry> calculated = Maps.newHashMap();
    @NotNull
    private final Set<ResourceLocation> blacklist = Sets.newHashSet();
    private boolean initialized = false;

    public void addCalculated(@NotNull Map<ResourceLocation, Integer> map) {
        for (Map.Entry<ResourceLocation, Integer> e : map.entrySet()) {
            this.addCalculated(e.getKey(), e.getValue());
        }
    }

    @Nullable
    public BiteableEntry calculate(@NotNull PathfinderMob creature) {
        if (!((Boolean)VampirismConfig.SERVER.autoCalculateEntityBlood.get()).booleanValue()) {
            return null;
        }
        EntityType type = creature.m_6095_();
        @Nullable ResourceLocation id = RegUtil.id(type);
        if (id == null) {
            return null;
        }
        if (this.blacklist.contains(id)) {
            return null;
        }
        if (this.isEntityBlacklisted(creature)) {
            this.blacklist.add(id);
            return null;
        }
        AABB bb = creature.m_20191_();
        double v = bb.f_82291_ - bb.f_82288_;
        v *= bb.f_82292_ - bb.f_82289_;
        v *= bb.f_82293_ - bb.f_82290_;
        if (creature.m_6162_()) {
            v *= 8.0;
        }
        int blood = 0;
        if (v >= 0.3) {
            blood = (int)(v * 7.0);
            blood = Math.min(15, blood);
        }
        if (creature.m_21233_() > 50.0f) {
            blood = 0;
        }
        LOGGER.debug("Calculated size {} and blood value {} for entity {}", (Object)Float.valueOf((float)Math.round(v * 100.0) / 100.0f), (Object)blood, (Object)id);
        if (blood == 0) {
            this.blacklist.add(id);
            return null;
        }
        return this.addCalculated(id, blood);
    }

    @Nullable
    public BiteableEntry get(@NotNull PathfinderMob creature) {
        if (!this.initialized) {
            return null;
        }
        return this.get(EntityType.m_20613_((EntityType)creature.m_6095_()));
    }

    @Nullable
    public BiteableEntry getOrCalculate(@NotNull PathfinderMob creature) {
        if (!this.initialized) {
            return null;
        }
        BiteableEntry entry = this.get(EntityType.m_20613_((EntityType)creature.m_6095_()));
        if (entry == null) {
            entry = this.calculate(creature);
        }
        return entry;
    }

    private BiteableEntry get(ResourceLocation id) {
        if (this.isConfigBlackListed(id)) {
            return null;
        }
        if (this.biteableEntries.containsKey(id)) {
            return this.biteableEntries.get(id);
        }
        return this.calculated.get(id);
    }

    @NotNull
    public Map<ResourceLocation, Integer> getValuesToSave() {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, BiteableEntry> entry : this.calculated.entrySet()) {
            if (this.biteableEntries.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue().blood);
        }
        return map;
    }

    public boolean init() {
        return this.initialized;
    }

    private BiteableEntry addCalculated(ResourceLocation id, int blood) {
        BiteableEntry existing = this.calculated.containsKey(id) ? this.calculated.get(id).modifyBloodValue(blood) : new BiteableEntry(blood);
        this.calculated.put(id, existing);
        return existing;
    }

    private boolean isConfigBlackListed(@NotNull ResourceLocation id) {
        List list = (List)VampirismConfig.SERVER.blacklistedBloodEntity.get();
        return list.contains(id.toString());
    }

    private boolean isEntityBlacklisted(PathfinderMob creature) {
        if (!(creature instanceof Animal)) {
            return true;
        }
        if (creature instanceof IVampire) {
            return true;
        }
        EntityType type = creature.m_6095_();
        if (type.m_20674_() == MobCategory.MONSTER || type.m_20674_() == MobCategory.WATER_CREATURE) {
            return true;
        }
        if (type.m_204039_(ModTags.Entities.VAMPIRE)) {
            return true;
        }
        return this.isConfigBlackListed(RegUtil.id(type));
    }

    void setNewBiteables(@NotNull Map<ResourceLocation, BiteableEntry> biteableEntries, @NotNull Set<ResourceLocation> blacklist) {
        this.biteableEntries.clear();
        this.blacklist.clear();
        this.biteableEntries.putAll(biteableEntries);
        this.blacklist.addAll(blacklist);
        this.initialized = true;
    }
}

