/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.client.renderer.entity.layers.ConvertedVampireEntityLayer;
import de.teamlapen.vampirism.data.reloadlistener.ConvertiblesReloadListener;
import de.teamlapen.vampirism.entity.converted.BiteableEntryManager;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.converted.converter.DefaultConverter;
import de.teamlapen.vampirism.mixin.client.LivingEntityRendererAccessor;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class VampirismEntityRegistry
implements IVampirismEntityRegistry {
    @NotNull
    public static final BiteableEntryManager biteableEntryManager = new BiteableEntryManager();
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final Map<EntityType<? extends PathfinderMob>, IConvertingHandler<?>> convertibles = new HashMap();
    @NotNull
    private final Map<EntityType<? extends PathfinderMob>, ResourceLocation> convertibleOverlay = new HashMap<EntityType<? extends PathfinderMob>, ResourceLocation>();
    private final Map<String, ResourceLocation> convertibleIdOverlay = new HashMap<String, ResourceLocation>();
    @NotNull
    private final Map<EntityType<? extends PathfinderMob>, IConvertingHandler<?>> convertiblesAPI = new ConcurrentHashMap();
    @NotNull
    private final Map<EntityType<? extends PathfinderMob>, ResourceLocation> convertibleOverlayAPI = new ConcurrentHashMap<EntityType<? extends PathfinderMob>, ResourceLocation>();
    private final Map<Class<? extends PathfinderMob>, Function<? extends PathfinderMob, IExtendedCreatureVampirism>> extendedCreatureConstructors = new ConcurrentHashMap<Class<? extends PathfinderMob>, Function<? extends PathfinderMob, IExtendedCreatureVampirism>>();
    private final BiFunction<IConvertingHandler.IDefaultHelper, @Nullable ResourceLocation, IConvertingHandler<?>> defaultConvertingHandlerCreator;
    private boolean finished = false;

    public VampirismEntityRegistry(BiFunction<IConvertingHandler.IDefaultHelper, @Nullable ResourceLocation, IConvertingHandler<?>> creator) {
        this.defaultConvertingHandlerCreator = creator;
    }

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, ResourceLocation overlayLocation) {
        this.addConvertible(type, overlayLocation, new DefaultConvertingHandler(null, overlayLocation));
    }

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, ResourceLocation overlay_loc, IConvertingHandler.IDefaultHelper helper) {
        this.addConvertible(type, overlay_loc, this.defaultConvertingHandlerCreator.apply(helper, overlay_loc));
    }

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, @Deprecated @Nullable ResourceLocation overlay_loc, @NotNull IConvertingHandler<?> handler) {
        if (this.finished) {
            throw new IllegalStateException("Register convertibles during InterModEnqueueEvent");
        }
        this.convertiblesAPI.put(type, handler);
        this.convertibleOverlayAPI.put(type, overlay_loc);
    }

    @Override
    public <T extends PathfinderMob> void addCustomExtendedCreature(Class<? extends T> clazz, Function<T, IExtendedCreatureVampirism> constructor) {
        if (this.finished) {
            throw new IllegalStateException("Register extended creatures during InterModEnqueueEvent");
        }
        this.extendedCreatureConstructors.put(clazz, constructor);
    }

    public void applyNewResources(@NotNull Map<ResourceLocation, Float> valuesIn) {
        HashMap values = Maps.newHashMap(valuesIn);
        HashMap biteables = Maps.newHashMap();
        HashSet blacklist = Sets.newHashSet();
        IConvertingHandler<?> defaultHandler = this.defaultConvertingHandlerCreator.apply(null, null);
        for (Map.Entry<EntityType<PathfinderMob>, IConvertingHandler<?>> entry : this.convertibles.entrySet()) {
            ResourceLocation id = RegUtil.id(entry.getKey());
            if (id == null) {
                LOGGER.warn("Cannot register convertible {} since there is no EntityString for it", entry.getKey());
                continue;
            }
            Float bloodF = (Float)values.remove(id);
            if (bloodF == null) {
                LOGGER.warn("Missing blood value for convertible creature {} ({})", (Object)entry.getKey().m_20676_(), (Object)id);
                continue;
            }
            int blood = Math.round(bloodF.floatValue());
            LOGGER.debug("Registering convertible {} with blood {} and handler {}", (Object)entry.getKey().m_20676_().getString(), (Object)blood, (Object)entry.getValue().getClass().getName());
            BiteableEntry biteEntry = new BiteableEntry(blood, entry.getValue() == null ? defaultHandler : entry.getValue());
            biteables.put(id, biteEntry);
        }
        LOGGER.info("Registered {} convertibles", (Object)biteables.size());
        for (Map.Entry<Object, IConvertingHandler<Object>> entry : values.entrySet()) {
            if (!RegUtil.has(ForgeRegistries.ENTITY_TYPES, (ResourceLocation)entry.getKey())) continue;
            int blood = Math.abs(Math.round(((Float)((Object)entry.getValue())).floatValue()));
            if (blood == 0) {
                blacklist.add((ResourceLocation)entry.getKey());
                continue;
            }
            biteables.put((ResourceLocation)entry.getKey(), new BiteableEntry(blood));
        }
        biteableEntryManager.setNewBiteables(biteables, blacklist);
        VampirismMod.proxy.applyConvertibleOverlays(this.convertibleOverlay);
    }

    @Override
    @Nullable
    public IConvertedCreature<?> convert(@NotNull PathfinderMob entity) {
        BiteableEntry b = biteableEntryManager.get(entity);
        if (b != null && b.convertingHandler != null) {
            return b.convertingHandler.createFrom(entity);
        }
        LOGGER.warn("Failed to find convertible entry for {}", (Object)entity);
        return null;
    }

    public void finishRegistration() {
        this.finished = true;
    }

    @Override
    @NotNull
    public Map<EntityType<? extends PathfinderMob>, ResourceLocation> getConvertibleOverlay() {
        return this.convertibleOverlay;
    }

    @Override
    @Nullable
    public ResourceLocation getConvertibleOverlay(String sourceEntity) {
        return this.convertibleIdOverlay.get(sourceEntity);
    }

    public @Unmodifiable Map<EntityType<? extends PathfinderMob>, IConvertingHandler<?>> getConvertibles() {
        return Collections.unmodifiableMap(this.convertibles);
    }

    @Override
    @Nullable
    public <T extends PathfinderMob> Function<T, IExtendedCreatureVampirism> getCustomExtendedCreatureConstructor(@NotNull T entity) {
        return this.extendedCreatureConstructors.get(entity.getClass());
    }

    @Override
    @Nullable
    public BiteableEntry getEntry(@NotNull PathfinderMob creature) {
        return biteableEntryManager.get(creature);
    }

    @Override
    @Nullable
    public BiteableEntry getOrCreateEntry(PathfinderMob creature) {
        return biteableEntryManager.getOrCalculate(creature);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyDataConvertibleOverlays(Map<EntityType<? extends PathfinderMob>, ResourceLocation> entries) {
        this.convertibleOverlay.clear();
        this.convertibleOverlay.putAll(this.convertibleOverlayAPI);
        this.convertibleOverlay.putAll(entries);
        this.syncOverlays();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <I extends LivingEntity, U extends EntityModel<I>> void syncOverlays() {
        this.convertibleIdOverlay.clear();
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        this.convertibleIdOverlay.putAll(this.convertibleOverlay.entrySet().stream().filter(s -> {
            AbstractTexture texture = textureManager.m_118506_((ResourceLocation)s.getValue());
            texture = textureManager.m_118506_((ResourceLocation)s.getValue());
            return texture != MissingTextureAtlasSprite.m_118080_();
        }).collect(Collectors.toMap(x -> ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)x.getKey())).toString(), Map.Entry::getValue)));
        for (EntityType<? extends PathfinderMob> type : this.getConvertibleOverlay().keySet()) {
            LivingEntityRenderer render = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(type);
            if (render == null) {
                LOGGER.error("Did not find renderer for {}", type);
                continue;
            }
            if (!((LivingEntityRendererAccessor)render).getLayers().stream().noneMatch(s -> s instanceof ConvertedVampireEntityLayer)) continue;
            render.m_115326_(new ConvertedVampireEntityLayer(render, true));
        }
    }

    public void applyDataConvertibles(Map<EntityType<? extends PathfinderMob>, ConvertiblesReloadListener.EntityEntry> entries) {
        this.convertibles.clear();
        this.convertibleOverlay.clear();
        this.convertibles.putAll(this.convertiblesAPI);
        this.convertibleOverlay.putAll(this.convertibleOverlayAPI);
        entries.forEach((type, entry) -> {
            Optional<IConvertingHandler> handler = entry.converter().map(c -> c.createHandler(entry.overlay().orElse(null)));
            this.convertibles.put((EntityType<? extends PathfinderMob>)type, handler.orElseGet(() -> new DefaultConverter().createHandler(entry.overlay().orElse(null))));
            entry.overlay().ifPresent(overlay -> this.convertibleOverlay.put((EntityType<? extends PathfinderMob>)type, (ResourceLocation)overlay));
        });
    }

    public record DatapackHelper(ConvertiblesReloadListener.EntityEntry.ConvertingAttributeModifier attributes) implements IConvertingHandler.IDefaultHelper
    {
        @Override
        public Map<Attribute, Pair<FloatProvider, Double>> getAttributeModifier() {
            return this.attributes.attributeModifier();
        }
    }
}

