/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModRefinements;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SunscreenVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    @Override
    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        this.applyEffect(vampire);
        return true;
    }

    @Override
    public int getCooldown(IVampirePlayer player) {
        return (Integer)VampirismConfig.BALANCE.vaSunscreenCooldown.get() * 20;
    }

    @Override
    public int getDuration(@NotNull IVampirePlayer player) {
        int duration = 20 * (Integer)VampirismConfig.BALANCE.vaSunscreenDuration.get();
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.SUN_SCREEN.get())) {
            duration = (int)((double)duration * (Double)VampirismConfig.BALANCE.vrSunscreenDurationMod.get());
        }
        return duration;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaSunscreenEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
    }

    @Override
    public void onDeactivated(@NotNull IVampirePlayer vampire) {
        this.removePotionEffect(vampire, (MobEffect)ModEffects.SUNSCREEN.get());
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        if (!vampire.isRemote() && vampire.getRepresentingPlayer().f_19797_ % 20 == 0) {
            this.applyEffect(vampire);
        }
        return false;
    }

    @Override
    public boolean showHudCooldown(Player player) {
        return true;
    }

    @Override
    public boolean showHudDuration(Player player) {
        return true;
    }

    protected void applyEffect(IVampirePlayer vampire) {
        this.addEffectInstance(vampire, new MobEffectInstance((MobEffect)ModEffects.SUNSCREEN.get(), 22, 3, false, false));
    }
}

