/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import de.maxanier.guideapi.api.SubTexture;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PagePotionTableMix
extends Page {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SubTexture POTION_GRID = new SubTexture(new ResourceLocation("vampirismguide", "textures/gui/potion_table.png"), 0, 0, 89, 75);
    private final Component description;
    private final ExtendedPotionMix @NotNull [] recipes;
    private long lastCycle = -1L;
    private ItemStack input;
    private ItemStack output;
    private ItemStack in1;
    private ItemStack in2;
    private int recipeCycle;
    private int currentIngredient1Index;
    @NotNull
    private @NotNull ItemStack @NotNull [] ingredients1 = new ItemStack[0];
    private int currentIngredient2Index;
    @NotNull
    private @NotNull ItemStack @NotNull [] ingredients2 = new ItemStack[0];

    public PagePotionTableMix(Component description, ExtendedPotionMix ... recipes) {
        assert (recipes.length > 0);
        this.description = description;
        this.recipes = recipes;
        this.deriveItemStacks(recipes[0]);
        this.in1 = this.ingredients1[0];
        this.in2 = this.ingredients2[0];
    }

    public PagePotionTableMix(Component description, @NotNull List<ExtendedPotionMix> recipes) {
        this(description, recipes.toArray(new ExtendedPotionMix[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(@NotNull GuiGraphics guiGraphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, @NotNull BaseScreen guiBase, Font font) {
        long time;
        long l = time = guiBase.getMinecraft().f_91073_ != null ? guiBase.getMinecraft().f_91073_.m_46467_() : 0L;
        if (this.lastCycle < 0L || this.lastCycle < time - 60L) {
            if (this.lastCycle > 0L) {
                this.cycle();
            }
            this.lastCycle = time;
        }
        int xStart = guiLeft + guiBase.xSize / 2 - 44;
        int yStart = guiTop + 20;
        POTION_GRID.draw(guiGraphics, xStart, yStart);
        List tooltip = null;
        int x = xStart + 7;
        int y = yStart + 55;
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)this.input, (int)x, (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.input);
        }
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)this.input, (int)(x += 21), (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.input);
        }
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)this.input, (int)(x += 21), (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.input);
        }
        x = xStart + 29;
        y = yStart + 4;
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)this.in1, (int)x, (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.in1);
        }
        x = xStart + 4;
        y = yStart + 12;
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)this.in2, (int)x, (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.in2);
        }
        x = xStart + 71;
        y = yStart + 29;
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)this.output, (int)x, (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.output);
        }
        PageHelper.drawFormattedText((GuiGraphics)guiGraphics, (int)(guiLeft + 43), (int)(yStart + 80), (BaseScreen)guiBase, (FormattedText)this.description);
        if (tooltip != null) {
            guiGraphics.m_280666_(font, tooltip, mouseX, mouseY);
        }
    }

    private void cycle() {
        if (++this.currentIngredient2Index >= this.ingredients2.length) {
            this.currentIngredient2Index = 0;
            if (++this.currentIngredient1Index >= this.ingredients1.length) {
                this.currentIngredient1Index = 0;
                if (++this.recipeCycle >= this.recipes.length) {
                    this.recipeCycle = 0;
                }
                this.deriveItemStacks(this.recipes[this.recipeCycle]);
            }
        }
        this.in1 = this.ingredients1[this.currentIngredient1Index];
        this.in2 = this.ingredients2[this.currentIngredient2Index];
    }

    private void deriveItemStacks(@NotNull ExtendedPotionMix recipe) {
        this.input = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)recipe.input.get());
        this.output = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)recipe.output.get());
        this.ingredients1 = (ItemStack[])recipe.reagent1.map(Ingredient::m_43908_).stream().flatMap(Arrays::stream).map(ItemStack::m_41777_).peek(stack -> stack.m_41764_(recipe.reagent1Count)).toArray(ItemStack[]::new);
        this.ingredients2 = (ItemStack[])recipe.reagent2.map(Ingredient::m_43908_).stream().flatMap(Arrays::stream).map(ItemStack::m_41777_).peek(stack -> stack.m_41764_(recipe.reagent2Count)).toArray(ItemStack[]::new);
        if (this.ingredients1.length == 0) {
            this.ingredients1 = new ItemStack[]{ItemStack.f_41583_};
        }
        if (this.ingredients2.length == 0) {
            this.ingredients2 = new ItemStack[]{ItemStack.f_41583_};
        }
    }
}

