/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.recipes;

import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.SubTexture;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.AlchemicalCauldronBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipe;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AlchemicalCauldronRecipeRenderer
extends IRecipeRenderer.RecipeRendererBase<AlchemicalCauldronRecipe> {
    private final SubTexture CRAFTING_GRID = new SubTexture(new ResourceLocation("vampirismguide", "textures/gui/alchemical_cauldron_recipe.png"), 0, 0, 110, 75);

    public AlchemicalCauldronRecipeRenderer(AlchemicalCauldronRecipe recipe) {
        super((Recipe)recipe);
    }

    public void draw(@NotNull GuiGraphics guiGraphics, RegistryAccess registryAccess, Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, int guiLeft, int guiTop, int mouseX, int mouseY, @NotNull BaseScreen baseScreen, @NotNull Font font, @NotNull IngredientCycler ingredientCycler) {
        this.CRAFTING_GRID.draw(guiGraphics, guiLeft + 60, guiTop + 42);
        baseScreen.drawCenteredStringWithoutShadow(guiGraphics, font, UtilLib.translate(((AlchemicalCauldronBlock)((Object)ModBlocks.ALCHEMICAL_CAULDRON.get())).m_7705_(), new Object[0]), guiLeft + baseScreen.xSize / 2, guiTop + 12, 0);
        String string = "\u00a7o" + UtilLib.translate("guideapi.text.crafting.shaped", new Object[0]) + "\u00a7r";
        int n = guiLeft + baseScreen.xSize / 2;
        Objects.requireNonNull(font);
        baseScreen.drawCenteredStringWithoutShadow(guiGraphics, font, string, n, guiTop + 14 + 9, 0);
        int outputX = guiLeft + 150;
        int outputY = guiTop + 72;
        int in1X = guiLeft + 78;
        int in1Y = guiTop + 59;
        int in2X = guiLeft + 108;
        int in2Y = guiTop + 59;
        ItemStack itemStack = ((AlchemicalCauldronRecipe)this.recipe).m_8043_(registryAccess);
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)itemStack, (int)outputX, (int)outputY);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
            this.tooltips = GuiHelper.getTooltip((ItemStack)itemStack);
        }
        Ingredient input = (Ingredient)((AlchemicalCauldronRecipe)this.recipe).m_7527_().get(0);
        ingredientCycler.getCycledIngredientStack(input, 0).ifPresent(inStack -> {
            GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)inStack, (int)in2X, (int)in2Y);
            if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)in2X, (int)in2Y, (int)15, (int)15)) {
                this.tooltips = GuiHelper.getTooltip((ItemStack)inStack);
            }
        });
        Ingredient liquid = (Ingredient)((AlchemicalCauldronRecipe)this.recipe).getFluid().map(ingredient -> ingredient, fluidStack -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{fluidStack.getFluid().m_6859_()}));
        ingredientCycler.getCycledIngredientStack(liquid, 1).ifPresent(fluidStack -> {
            GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)fluidStack, (int)in1X, (int)in1Y);
            if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)in1X, (int)in1Y, (int)15, (int)15)) {
                this.tooltips = GuiHelper.getTooltip((ItemStack)fluidStack);
            }
        });
        int y = guiTop + 120;
        if (((AlchemicalCauldronRecipe)this.recipe).getRequiredLevel() > 1) {
            MutableComponent level = Component.m_237110_((String)"gui.vampirism.hunter_weapon_table.level", (Object[])new Object[]{((AlchemicalCauldronRecipe)this.recipe).getRequiredLevel()});
            guiGraphics.m_280614_(font, (Component)level, guiLeft + 50, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(font);
            y += 9 + 2;
        }
        if (((AlchemicalCauldronRecipe)this.recipe).getRequiredSkills().length > 0) {
            MutableComponent newLine = Component.m_237113_((String)"\n");
            ArrayList<MutableComponent> skills = new ArrayList<MutableComponent>();
            skills.add(Component.m_237110_((String)"gui.vampirism.skill_required", (Object[])new Object[]{"\n"}));
            for (ISkill<?> skill : ((AlchemicalCauldronRecipe)this.recipe).getRequiredSkills()) {
                skills.add(skill.getName().m_6881_().m_130940_(ChatFormatting.ITALIC));
                skills.add(newLine);
            }
            guiGraphics.m_280554_(font, FormattedText.m_130768_(skills), guiLeft + 50, y, 100, Color.GRAY.getRGB());
        }
    }
}

