/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.PotionTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.modcompat.jei.JEIPotionMix;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PotionTableRecipeCategory
implements IRecipeCategory<JEIPotionMix> {
    private static final ResourceLocation backgroundLocation = new ResourceLocation("vampirism", "textures/gui/potion_table.png");
    @NotNull
    private final Component localizedName = Component.m_237115_((String)((PotionTableBlock)((Object)ModBlocks.POTION_TABLE.get())).m_7705_());
    @NotNull
    private final IDrawable background;
    @NotNull
    private final IDrawable icon;
    @NotNull
    private final IDrawable slotDrawable;
    @NotNull
    private final IDrawableAnimated arrow;
    @NotNull
    private final IDrawableAnimated bubbles;
    @NotNull
    private final IDrawableStatic blazeHeat;

    PotionTableRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.POTION_TABLE.get()));
        this.background = guiHelper.drawableBuilder(backgroundLocation, 65, 6, 103, 73).addPadding(0, 33, 0, 25).build();
        this.slotDrawable = guiHelper.getSlotDrawable();
        BrewingBubblesTickTimer bubblesTickTimer = new BrewingBubblesTickTimer(guiHelper);
        this.bubbles = guiHelper.drawableBuilder(backgroundLocation, 185, 0, 12, 29).buildAnimated((ITickTimer)bubblesTickTimer, IDrawableAnimated.StartDirection.BOTTOM);
        this.blazeHeat = guiHelper.createDrawable(backgroundLocation, 176, 29, 18, 4);
        this.arrow = guiHelper.drawableBuilder(backgroundLocation, 176, 0, 9, 28).buildAnimated(400, IDrawableAnimated.StartDirection.TOP, false);
    }

    public void draw(@NotNull JEIPotionMix recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        this.blazeHeat.draw(graphics, 1, 35);
        this.bubbles.draw(graphics, 3, 4);
        this.arrow.draw(graphics, 80, 10);
        int y = 75;
        int x = 5;
        Minecraft minecraft = Minecraft.m_91087_();
        if (recipe.getOriginal().durable && recipe.getOriginal().concentrated) {
            graphics.m_280614_(minecraft.f_91062_, ((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        } else if (recipe.getOriginal().durable) {
            graphics.m_280614_(minecraft.f_91062_, ((ISkill)HunterSkills.DURABLE_BREWING.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        } else if (recipe.getOriginal().concentrated) {
            graphics.m_280614_(minecraft.f_91062_, ((ISkill)HunterSkills.CONCENTRATED_BREWING.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        }
        if (recipe.getOriginal().master) {
            graphics.m_280614_(minecraft.f_91062_, ((ISkill)HunterSkills.MASTER_BREWER.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        }
        if (recipe.getOriginal().efficient) {
            graphics.m_280614_(minecraft.f_91062_, ((ISkill)HunterSkills.EFFICIENT_BREWING.get()).getName(), x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public RecipeType<JEIPotionMix> getRecipeType() {
        return VampirismJEIPlugin.POTION;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull JEIPotionMix recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 39, 53).addItemStack(recipe.getPotionInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 61, 53).addItemStack(recipe.getPotionInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 83, 53).addItemStack(recipe.getPotionInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 61, 2).addItemStacks(recipe.getMix1());
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 10).addItemStacks(recipe.getMix2());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 105, 15).addItemStack(recipe.getPotionOutput())).setBackground(this.slotDrawable, -1, -1);
    }

    private static class BrewingBubblesTickTimer
    implements ITickTimer {
        private static final int[] BUBBLE_LENGTHS = new int[]{29, 23, 18, 13, 9, 5, 0};
        @NotNull
        private final ITickTimer internalTimer;

        public BrewingBubblesTickTimer(@NotNull IGuiHelper guiHelper) {
            this.internalTimer = guiHelper.createTickTimer(14, BUBBLE_LENGTHS.length - 1, false);
        }

        public int getMaxValue() {
            return BUBBLE_LENGTHS[0];
        }

        public int getValue() {
            int timerValue = this.internalTimer.getValue();
            return BUBBLE_LENGTHS[timerValue];
        }
    }
}

