/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.network.ServerboundSelectMinionTaskPacket;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public record ClientboundRequestMinionSelectPacket(Action action, List<Pair<Integer, Component>> minions) implements IMessage.IClientBoundMessage
{
    @NotNull
    public static Optional<ClientboundRequestMinionSelectPacket> createRequestForPlayer(@NotNull ServerPlayer player, Action action) {
        return FactionPlayerHandler.getOpt((Player)player).resolve().flatMap(fp -> {
            PlayerMinionController controller = MinionWorldData.getData(player.f_8924_).getOrCreateController((FactionPlayerHandler)fp);
            Collection<Integer> ids = controller.getCallableMinions();
            if (ids.size() > 0) {
                ArrayList<Pair<Integer, Component>> minions = new ArrayList<Pair<Integer, Component>>(ids.size());
                ids.forEach(id -> controller.contactMinionData((int)id, data -> data.getFormattedName().m_6881_()).ifPresent(n -> minions.add(Pair.of((Object)id, (Object)n))));
                return Optional.of(new ClientboundRequestMinionSelectPacket(action, minions));
            }
            ServerboundSelectMinionTaskPacket.printRecoveringMinions(player, controller.getRecoveringMinionNames());
            return Optional.empty();
        });
    }

    public static void handle(@NotNull ClientboundRequestMinionSelectPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleRequestMinionSelect(msg.action, msg.minions));
        ctx.setPacketHandled(true);
    }

    static void encode(@NotNull ClientboundRequestMinionSelectPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130130_(msg.action.ordinal());
        buf.m_130130_(msg.minions.size());
        for (Pair<Integer, Component> minion : msg.minions) {
            buf.m_130130_(((Integer)minion.getLeft()).intValue());
            buf.m_130083_((Component)minion.getRight());
        }
    }

    @NotNull
    static ClientboundRequestMinionSelectPacket decode(@NotNull FriendlyByteBuf buf) {
        Action a = Action.values()[buf.m_130242_()];
        int count = buf.m_130242_();
        ArrayList<Pair<Integer, Component>> minions = new ArrayList<Pair<Integer, Component>>(count);
        for (int i = 0; i < count; ++i) {
            minions.add((Pair<Integer, Component>)Pair.of((Object)buf.m_130242_(), (Object)buf.m_130238_()));
        }
        return new ClientboundRequestMinionSelectPacket(a, minions);
    }

    public static enum Action {
        CALL;

    }
}

