/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.player.TaskManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public record ClientboundTaskPacket(int containerId, Map<UUID, TaskManager.TaskWrapper> taskWrappers, Map<UUID, Set<UUID>> completableTasks, Map<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements) implements IMessage.IClientBoundMessage
{
    private static final Codec<UUID> UUID_CODEC = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)UUID.fromString(s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid UUID: " + s);
        }
    }, UUID::toString).stable();
    private static final Codec<Set<UUID>> SET_CODEC = UUID_CODEC.listOf().comapFlatMap(s -> {
        try {
            return DataResult.success(new HashSet(s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid List");
        }
    }, ArrayList::new).stable();
    private static final Codec<ClientboundTaskPacket> CODEC = RecordCodecBuilder.create(func -> func.group((App)Codec.INT.fieldOf("containerId").forGetter(ClientboundTaskPacket::containerId), (App)Codec.unboundedMap(UUID_CODEC, TaskManager.TaskWrapper.CODEC).fieldOf("taskWrappers").forGetter(ClientboundTaskPacket::taskWrappers), (App)Codec.unboundedMap(UUID_CODEC, SET_CODEC).fieldOf("completableTasks").forGetter(ClientboundTaskPacket::completableTasks), (App)Codec.unboundedMap(UUID_CODEC, (Codec)Codec.unboundedMap(UUID_CODEC, (Codec)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.INT))).fieldOf("completedRequirements").forGetter(ClientboundTaskPacket::completedRequirements)).apply((Applicative)func, ClientboundTaskPacket::new));

    public static void encode(@NotNull ClientboundTaskPacket msg, @NotNull FriendlyByteBuf buffer) {
        buffer.m_272073_(CODEC, (Object)msg);
    }

    @NotNull
    public static ClientboundTaskPacket decode(@NotNull FriendlyByteBuf buffer) {
        return (ClientboundTaskPacket)buffer.m_271872_(CODEC);
    }

    public static void handle(ClientboundTaskPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleTaskPacket(msg));
        ctx.setPacketHandled(true);
    }
}

