/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.TaskManager;
import de.teamlapen.vampirism.inventory.TaskMenu;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public record ServerboundTaskActionPacket(UUID task, UUID entityId, TaskMenu.TaskAction action) implements IMessage.IServerBoundMessage
{
    static void encode(@NotNull ServerboundTaskActionPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130077_(msg.task);
        buf.m_130077_(msg.entityId);
        buf.m_130130_(msg.action.ordinal());
    }

    @NotNull
    static ServerboundTaskActionPacket decode(@NotNull FriendlyByteBuf buf) {
        return new ServerboundTaskActionPacket(buf.m_130259_(), buf.m_130259_(), TaskMenu.TaskAction.values()[buf.m_130242_()]);
    }

    public static void handle(@NotNull ServerboundTaskActionPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> FactionPlayerHandler.getCurrentFactionPlayer((Player)ctx.getSender()).map(IFactionPlayer::getTaskManager).ifPresent(m -> ((TaskManager)m).handleTaskActionMessage(msg)));
        ctx.setPacketHandled(true);
    }
}

