/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public record ServerboundToggleMinionTaskLock(int minionID) implements IMessage.IServerBoundMessage
{
    static void encode(@NotNull ServerboundToggleMinionTaskLock msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130130_(msg.minionID);
    }

    @NotNull
    static ServerboundToggleMinionTaskLock decode(@NotNull FriendlyByteBuf buf) {
        return new ServerboundToggleMinionTaskLock(buf.m_130242_());
    }

    static void handle(@NotNull ServerboundToggleMinionTaskLock msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> FactionPlayerHandler.getOpt((Player)ctx.getSender()).ifPresent(fp -> {
            PlayerMinionController controller = MinionWorldData.getData(ctx.getSender().f_8924_).getOrCreateController((FactionPlayerHandler)fp);
            controller.contactMinionData(msg.minionID, data -> data.setTaskLocked(!data.isTaskLocked()));
            controller.contactMinion(msg.minionID, MinionEntity::onTaskChanged);
        }));
        ctx.setPacketHandled(true);
    }
}

