/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.proxy;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.client.VIngameOverlays;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.blockentity.FogDiffuserBlockEntity;
import de.teamlapen.vampirism.blockentity.GarlicDiffuserBlockEntity;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.LogBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.client.core.ClientEventHandler;
import de.teamlapen.vampirism.client.core.ModBlocksRender;
import de.teamlapen.vampirism.client.core.ModItemsRender;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.core.ModScreens;
import de.teamlapen.vampirism.client.gui.ScreenEventHandler;
import de.teamlapen.vampirism.client.gui.overlay.ActionCooldownOverlay;
import de.teamlapen.vampirism.client.gui.overlay.ActionDurationOverlay;
import de.teamlapen.vampirism.client.gui.overlay.BloodBarOverlay;
import de.teamlapen.vampirism.client.gui.overlay.CustomBossEventOverlay;
import de.teamlapen.vampirism.client.gui.overlay.FactionLevelOverlay;
import de.teamlapen.vampirism.client.gui.overlay.VampirismHUDOverlay;
import de.teamlapen.vampirism.client.gui.screens.ActionSelectScreen;
import de.teamlapen.vampirism.client.gui.screens.DBNOScreen;
import de.teamlapen.vampirism.client.gui.screens.FogDiffuserScreen;
import de.teamlapen.vampirism.client.gui.screens.GarlicDiffuserScreen;
import de.teamlapen.vampirism.client.gui.screens.NameSwordScreen;
import de.teamlapen.vampirism.client.gui.screens.RevertBackScreen;
import de.teamlapen.vampirism.client.gui.screens.SelectMinionScreen;
import de.teamlapen.vampirism.client.gui.screens.VampireBookScreen;
import de.teamlapen.vampirism.client.renderer.RenderHandler;
import de.teamlapen.vampirism.client.renderer.blockentity.ModBlockEntityItemRenderer;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.player.skills.ClientSkillTreeManager;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import de.teamlapen.vampirism.inventory.TaskBoardMenu;
import de.teamlapen.vampirism.inventory.VampirismMenu;
import de.teamlapen.vampirism.network.ClientboundBloodValuePacket;
import de.teamlapen.vampirism.network.ClientboundPlayEventPacket;
import de.teamlapen.vampirism.network.ClientboundRequestMinionSelectPacket;
import de.teamlapen.vampirism.network.ClientboundSkillTreePacket;
import de.teamlapen.vampirism.network.ClientboundTaskPacket;
import de.teamlapen.vampirism.network.ClientboundTaskStatusPacket;
import de.teamlapen.vampirism.network.ClientboundUpdateMultiBossEventPacket;
import de.teamlapen.vampirism.proxy.CommonProxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final Logger LOGGER = LogManager.getLogger(ClientProxy.class);
    private final ClientSkillTreeManager skillTreeManager = new ClientSkillTreeManager();
    private VampirismHUDOverlay overlay;
    private CustomBossEventOverlay bossInfoOverlay;
    private RenderHandler renderHandler;
    private Map<UUID, ResourceKey<SoundEvent>> bossEventSounds = new HashMap<UUID, ResourceKey<SoundEvent>>();
    private ModBlockEntityItemRenderer blockEntityItemRenderer;

    public ClientProxy() {
        Minecraft instance = Minecraft.m_91087_();
        if (instance != null) {
            this.renderHandler = new RenderHandler(instance);
            MinecraftForge.EVENT_BUS.register((Object)this.renderHandler);
            ((ReloadableResourceManager)instance.m_91098_()).m_7217_((PreparableReloadListener)this.renderHandler);
        }
    }

    public void clearBossBarOverlay() {
        this.bossInfoOverlay.clear();
    }

    @Override
    public void displayGarlicBeaconScreen(GarlicDiffuserBlockEntity tile, Component title) {
        ClientProxy.openScreen(new GarlicDiffuserScreen(tile, title));
    }

    @Override
    public void displayFogDiffuserScreen(FogDiffuserBlockEntity tile, Component title) {
        ClientProxy.openScreen(new FogDiffuserScreen(tile, title));
    }

    @Override
    public void displayNameSwordScreen(ItemStack stack) {
        ClientProxy.openScreen(new NameSwordScreen(stack));
    }

    @Override
    public void displayRevertBackScreen() {
        ClientProxy.openScreen((Screen)new RevertBackScreen());
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    @Nullable
    public Entity getMouseOverEntity() {
        HitResult r = Minecraft.m_91087_().f_91077_;
        if (r instanceof EntityHitResult) {
            return ((EntityHitResult)r).m_82443_();
        }
        return null;
    }

    @Override
    public float getRenderPartialTick() {
        return Minecraft.m_91087_().m_91296_();
    }

    @Override
    public SkillTree getSkillTree(boolean client) {
        return client ? this.skillTreeManager.getSkillTree() : super.getSkillTree(false);
    }

    @Override
    public void handleBloodValuePacket(@NotNull ClientboundBloodValuePacket msg) {
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).applyDataConvertibleOverlays(msg.convertibleOverlay());
        Map<ResourceLocation, Float> entities = msg.getValues()[0];
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).applyNewResources(entities);
        BloodConversionRegistry.applyNewEntitiesResources(entities);
        BloodConversionRegistry.applyNewItemResources(msg.getValues()[1]);
        BloodConversionRegistry.applyNewFluidResources(msg.getValues()[2]);
    }

    @Override
    public void handlePlayEventPacket(@NotNull ClientboundPlayEventPacket msg) {
        if (msg.type() == 1) {
            this.spawnParticles((Level)Minecraft.m_91087_().f_91073_, msg.pos(), Block.m_49803_((int)msg.stateId()));
        } else if (msg.type() == 2) {
            Minecraft.m_91087_().m_91397_().m_120186_();
        }
    }

    @Override
    public void handleRequestMinionSelect(ClientboundRequestMinionSelectPacket.Action action, @NotNull List<Pair<Integer, Component>> minions) {
        ClientProxy.openScreen(new SelectMinionScreen(action, minions));
    }

    @Override
    public void handleSkillTreePacket(@NotNull ClientboundSkillTreePacket msg) {
        this.skillTreeManager.loadUpdate(msg);
    }

    @Override
    public void handleSleepClient(@NotNull Player player) {
        if (player.m_5803_()) {
            player.m_21257_().ifPresent(pos -> {
                if (player.m_9236_().m_8055_(pos).m_60734_() instanceof TentBlock) {
                    TentBlock.setTentSleepPosition(player, pos, (Integer)player.m_9236_().m_8055_(pos).m_61143_((Property)TentBlock.POSITION), (Direction)player.m_9236_().m_8055_(pos).m_61143_((Property)TentBlock.FACING));
                } else if (player.m_9236_().m_8055_(pos).m_60734_() instanceof CoffinBlock) {
                    CoffinBlock.setCoffinSleepPosition(player, pos, player.m_9236_().m_8055_(pos));
                }
            });
        }
    }

    @Override
    public void handleTaskPacket(@NotNull ClientboundTaskPacket msg) {
        AbstractContainerMenu container = Minecraft.m_91087_().f_91074_.f_36096_;
        if (msg.containerId() == container.f_38840_ && container instanceof VampirismMenu) {
            ((VampirismMenu)container).init(msg.taskWrappers(), msg.completableTasks(), msg.completedRequirements());
        }
    }

    @Override
    public void handleTaskStatusPacket(@NotNull ClientboundTaskStatusPacket msg) {
        AbstractContainerMenu container = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).f_36096_;
        if (msg.containerId() == container.f_38840_ && container instanceof TaskBoardMenu) {
            ((TaskBoardMenu)container).init(msg.available(), msg.completableTasks(), msg.completedRequirements(), msg.taskBoardId());
        }
    }

    @Override
    public void handleUpdateMultiBossInfoPacket(@NotNull ClientboundUpdateMultiBossEventPacket msg) {
        this.bossInfoOverlay.read(msg);
    }

    @Override
    public void handleVampireBookPacket( @NotNull VampireBookManager.BookInfo bookInfo) {
        ClientProxy.openScreen(new VampireBookScreen(bookInfo));
    }

    @Override
    public void onInitStep(@NotNull IInitListener.Step step, @NotNull ParallelDispatchEvent event) {
        super.onInitStep(step, event);
        switch (step) {
            case CLIENT_SETUP: {
                Minecraft instance = Minecraft.m_91087_();
                this.overlay = new VampirismHUDOverlay(instance);
                this.registerSubscriptions();
                ActionSelectScreen.loadActionOrder();
                ModBlocksRender.register();
                event.enqueueWork(() -> {
                    Sheets.addWoodType((WoodType)LogBlock.DARK_SPRUCE);
                    Sheets.addWoodType((WoodType)LogBlock.CURSED_SPRUCE);
                });
                break;
            }
            case LOAD_COMPLETE: {
                event.enqueueWork(ModItemsRender::registerItemModelPropertyUnsafe);
                event.enqueueWork(ModScreens::registerScreensUnsafe);
                this.skillTreeManager.init();
                break;
            }
        }
    }

    @Override
    public void renderScreenFullColor(int ticksOn, int ticksOff, int color) {
        if (this.overlay != null) {
            this.overlay.makeRenderFullColor(ticksOn, ticksOff, color);
        }
    }

    @Override
    public void showDBNOScreen(@NotNull Player playerEntity, @Nullable Component deathMessage) {
        if (playerEntity == Minecraft.m_91087_().f_91074_ && !playerEntity.m_21224_()) {
            ClientProxy.openScreen(new DBNOScreen(deathMessage));
        }
    }

    private void registerSubscriptions() {
        MinecraftForge.EVENT_BUS.register((Object)this.overlay);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ScreenEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModKeys());
    }

    @Override
    public void setupAPIClient() {
        this.bossInfoOverlay = new CustomBossEventOverlay();
        VIngameOverlays.FACTION_RAID_BAR_ELEMENT = this.bossInfoOverlay;
        VIngameOverlays.BLOOD_BAR_ELEMENT = new BloodBarOverlay();
        VIngameOverlays.FACTION_LEVEL_ELEMENT = new FactionLevelOverlay();
        VIngameOverlays.ACTION_COOLDOWN_ELEMENT = new ActionCooldownOverlay();
        VIngameOverlays.ACTION_DURATION_ELEMENT = new ActionDurationOverlay();
    }

    private void spawnParticles(Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (!(world instanceof ClientLevel)) {
            return;
        }
        VoxelShape voxelshape = state.m_60808_((BlockGetter)world, pos);
        voxelshape.m_83286_((p_199284_3_, p_199284_5_, p_199284_7_, p_199284_9_, p_199284_11_, p_199284_13_) -> {
            double d1 = Math.min(1.0, p_199284_9_ - p_199284_3_);
            double d2 = Math.min(1.0, p_199284_11_ - p_199284_5_);
            double d3 = Math.min(1.0, p_199284_13_ - p_199284_7_);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
            for (int l = 0; l < i / 2; ++l) {
                for (int i1 = 0; i1 < j / 2; ++i1) {
                    for (int j1 = 0; j1 < k / 2; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + p_199284_3_;
                        double d8 = d5 * d2 + p_199284_5_;
                        double d9 = d6 * d3 + p_199284_7_;
                        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new TerrainParticle((ClientLevel)world, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state));
                    }
                }
            }
        });
    }

    @Override
    public void endBloodVisionBatch() {
        this.renderHandler.endBloodVisionBatch();
    }

    public static void runOnRenderThread(Runnable runnable) {
        Minecraft.m_91087_().execute(runnable);
    }

    public static void openScreen(Screen screen) {
        ClientProxy.runOnRenderThread(() -> Minecraft.m_91087_().m_91152_(screen));
    }

    public static ClientProxy get() {
        return (ClientProxy)VampirismMod.proxy;
    }

    public ModBlockEntityItemRenderer getBlockEntityItemRenderer() {
        return this.blockEntityItemRenderer;
    }

    @Override
    public void addBossEventSound(UUID bossEventUuid, ResourceKey<SoundEvent> sound) {
        this.bossEventSounds.put(bossEventUuid, sound);
    }

    public ResourceKey<SoundEvent> getBossEventSound(UUID bossEventUuid) {
        return this.bossEventSounds.get(bossEventUuid);
    }

    public void registerBlockEntityItemRenderer() {
        this.blockEntityItemRenderer = new ModBlockEntityItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }
}

