/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.vampirehut;

import de.teamlapen.vampirism.blocks.LogBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.core.ModStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class VampireHutPieces {
    private static final ResourceLocation LOCATION = new ResourceLocation("vampirism", "vampire_hut");

    public static void addPieces(StructureTemplateManager structureTemplateManager, StructurePieceAccessor pieceAccessor, RandomSource random, BlockPos pos) {
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        pieceAccessor.m_142679_((StructurePiece)new VampireHutPiece(structureTemplateManager, LOCATION, pos, rotation));
    }

    public static class VampireHutPiece
    extends TemplateStructurePiece {
        public VampireHutPiece(StructureTemplateManager pStructureTemplateManager, ResourceLocation pLocation, BlockPos pPos, Rotation pRotation) {
            super((StructurePieceType)ModStructures.VAMPIRE_HUT_PIECE.get(), 0, pStructureTemplateManager, pLocation, pLocation.toString(), VampireHutPiece.makeSettings(pRotation), pPos);
        }

        public VampireHutPiece(StructureTemplateManager pStructureTemplateManager, CompoundTag pTag) {
            super((StructurePieceType)ModStructures.VAMPIRE_HUT_PIECE.get(), pTag, pStructureTemplateManager, id -> VampireHutPiece.makeSettings(Rotation.valueOf((String)pTag.m_128461_("Rot"))));
        }

        protected void m_183620_(@NotNull StructurePieceSerializationContext pContext, @NotNull CompoundTag pTag) {
            super.m_183620_(pContext, pTag);
            pTag.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        protected void m_213704_(@NotNull String pName, @NotNull BlockPos pPos, @NotNull ServerLevelAccessor pLevel, @NotNull RandomSource pRandom, @NotNull BoundingBox pBox) {
            switch (pName) {
                case "chest": {
                    pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
                    BlockEntity blockEntity = pLevel.m_7702_(pPos.m_7495_());
                    if (!(blockEntity instanceof ChestBlockEntity)) break;
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    chest.m_59626_(ModLootTables.CHEST_VAMPIRE_HUT, pRandom.m_188505_());
                    break;
                }
                case "log": {
                    BlockState state = (BlockState)((LogBlock)((Object)ModBlocks.DARK_SPRUCE_LOG.get())).m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y);
                    pLevel.m_7731_(pPos, state, 3);
                    BlockPos down = pPos.m_7495_();
                    while (pLevel.m_8055_(down).m_247087_()) {
                        pLevel.m_7731_(down, state, 3);
                        down = down.m_7495_();
                    }
                    break;
                }
            }
        }

        public void m_213694_(WorldGenLevel pLevel, @NotNull StructureManager pStructureManager, @NotNull ChunkGenerator pGenerator, @NotNull RandomSource pRandom, @NotNull BoundingBox pBox, @NotNull ChunkPos pChunkPos, BlockPos pPos) {
            int i = pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pPos.m_123341_(), pPos.m_123343_());
            BlockPos oldPos = this.f_73658_;
            this.f_73658_ = this.f_73658_.m_7918_(0, i - 90, 0);
            super.m_213694_(pLevel, pStructureManager, pGenerator, pRandom, pBox, pChunkPos, pPos);
            this.f_73658_ = oldPos;
        }

        @NotNull
        private static StructurePlaceSettings makeSettings(Rotation pRotation) {
            return new StructurePlaceSettings().m_74379_(pRotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
        }
    }
}

