/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.util.OilUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.stream.Collector;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SmeltItemLootModifier
extends LootModifier {
    public static final Codec<SmeltItemLootModifier> CODEC = RecordCodecBuilder.create(inst -> SmeltItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SmeltItemLootModifier::new));

    protected SmeltItemLootModifier(LootItemCondition @NotNull [] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        ItemStack stack = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (!(entity instanceof LivingEntity) || stack == null || OilUtils.getAppliedOil(stack).filter(oil -> oil == ModOils.SMELT.get()).isEmpty()) {
            return generatedLoot;
        }
        stack = ((LivingEntity)entity).m_21205_();
        OilUtils.reduceAppliedOilDuration(stack);
        return this.trySmelting(generatedLoot, context.m_78952_());
    }

    private ObjectArrayList<ItemStack> trySmelting(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull ServerLevel level) {
        RecipeManager recipeManager = level.m_7465_();
        return generatedLoot.stream().map(stack -> recipeManager.m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)level).map(recipe -> recipe.m_8043_(level.m_9598_())).filter(result -> !result.m_41619_()).orElse((ItemStack)stack)).collect(Collector.of(ObjectArrayList::new, ObjectArrayList::add, (left, right) -> {
            left.addAll((ObjectList)right);
            return left;
        }, new Collector.Characteristics[0]));
    }

    @NotNull
    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)ModLoot.SMELTING.get();
    }
}

