/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.capabilities;

import com.github.L_Ender.cataclysm.client.particle.RingParticle;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.projectile.Phantom_Halberd_Entity;
import com.github.L_Ender.cataclysm.init.ModCapabilities;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class RenderRushCapability {
    public static ResourceLocation ID = new ResourceLocation("cataclysm", "render_rush_cap");

    public static class RenderRushCapabilityImp
    implements IRenderRushCapability {
        private boolean rush;
        public int Timer;
        public float damage;

        @Override
        public void tick(LivingEntity entity) {
            if (this.isRush()) {
                int standingOnY = Mth.m_14107_((double)entity.m_20186_()) - 3;
                double headY = entity.m_20186_() + 2.0;
                float yawRadians = (float)Math.toRadians(90.0f + entity.m_146908_());
                int temp = this.getTimer();
                this.setTimer(temp - 1);
                if (temp > 0) {
                    double yaw = Math.toRadians(entity.m_146908_() + 90.0f);
                    double xExpand = 3.0 * Math.cos(yaw);
                    double zExpand = 3.0 * Math.sin(yaw);
                    AABB attackRange = entity.m_20191_().m_82363_(xExpand, 0.0, zExpand);
                    for (LivingEntity target : entity.m_9236_().m_45976_(LivingEntity.class, attackRange)) {
                        if (target.m_7307_((Entity)entity) || target == entity) continue;
                        target.m_6469_(entity.m_269291_().m_269333_(entity), this.getdamage());
                    }
                    if (temp % 2 == 0) {
                        this.spawnFangs(entity.m_20185_(), headY, entity.m_20189_(), standingOnY, yawRadians, 1, entity.m_9236_(), entity);
                        double x = entity.m_20185_();
                        double y = entity.m_20186_() + (double)(entity.m_20206_() / 2.0f);
                        double z = entity.m_20189_();
                        float yaw2 = (float)Math.toRadians(-entity.m_146908_());
                        float yaw3 = (float)Math.toRadians(-entity.m_146908_() + 180.0f);
                        entity.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(yaw2, 0.0f, 20, 0.337f, 0.925f, 0.8f, 1.0f, 30.0f, false, RingParticle.EnumRingBehavior.GROW_THEN_SHRINK), x, y, z, 0.0, 0.0, 0.0);
                        entity.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(yaw3, 0.0f, 20, 0.337f, 0.925f, 0.8f, 1.0f, 30.0f, false, RingParticle.EnumRingBehavior.GROW_THEN_SHRINK), x, y, z, 0.0, 0.0, 0.0);
                    }
                }
                if (temp == 0) {
                    this.setRush(false);
                }
            }
        }

        private void spawnFangs(double x, double y, double z, int lowestYCheck, float yRot, int warmupDelayTicks, Level world, LivingEntity player) {
            BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = world.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)world, blockpos1, Direction.UP)) continue;
                if (!world.m_46859_(blockpos) && !(voxelshape = (blockstate1 = world.m_8055_(blockpos)).m_60812_((BlockGetter)world, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= lowestYCheck);
            if (flag) {
                world.m_7967_((Entity)new Phantom_Halberd_Entity(world, x, (double)blockpos.m_123342_() + d0, z, yRot, warmupDelayTicks, player, (float)CMConfig.PhantomHalberddamage));
            }
        }

        @Override
        public void setRush(boolean charge) {
            this.rush = charge;
        }

        @Override
        public boolean isRush() {
            return this.rush;
        }

        @Override
        public void setdamage(float damage) {
            this.damage = damage;
        }

        @Override
        public float getdamage() {
            return this.damage;
        }

        @Override
        public void setTimer(int timer) {
            this.Timer = timer;
        }

        @Override
        public int getTimer() {
            return this.Timer;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("isRush", this.isRush());
            tag.m_128350_("damage", this.getdamage());
            tag.m_128405_("timer", this.getTimer());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setRush(nbt.m_128471_("isRush"));
            this.setdamage(nbt.m_128457_("damage"));
            this.setTimer(nbt.m_128451_("timer"));
        }

        public static class RenderRushProvider
        implements ICapabilityProvider,
        ICapabilitySerializable<CompoundTag> {
            private final LazyOptional<IRenderRushCapability> instance = LazyOptional.of(RenderRushCapabilityImp::new);

            public CompoundTag serializeNBT() {
                return (CompoundTag)((IRenderRushCapability)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
            }

            public void deserializeNBT(CompoundTag nbt) {
                ((IRenderRushCapability)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
                return ModCapabilities.RENDER_RUSH_CAPABILITY.orEmpty(cap, this.instance.cast());
            }
        }
    }

    public static interface IRenderRushCapability
    extends INBTSerializable<CompoundTag> {
        public void tick(LivingEntity var1);

        public void setRush(boolean var1);

        public boolean isRush();

        public void setTimer(int var1);

        public int getTimer();

        public void setdamage(float var1);

        public float getdamage();
    }
}

