/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.sound;

import com.bobmowzie.mowziesmobs.client.sound.BossMusic;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.ilexiconn.llibrary.client.model.tools.ControlledAnimation;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BossMusicSound
extends AbstractTickableSoundInstance {
    private MowzieEntity boss;
    private BossMusic music;
    private final SoundEvent soundEvent;
    ControlledAnimation volumeControl;
    private boolean shouldPlay;

    public BossMusicSound(SoundEvent sound, MowzieEntity boss, BossMusic music) {
        this(sound, boss, music, true);
    }

    public BossMusicSound(SoundEvent sound, MowzieEntity boss, BossMusic music, boolean looping) {
        super(sound, SoundSource.MUSIC, SoundInstance.m_235150_());
        this.soundEvent = sound;
        this.boss = boss;
        this.music = music;
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        this.f_119578_ = looping;
        this.f_119579_ = 0;
        this.f_119575_ = boss.m_20185_();
        this.f_119576_ = boss.m_20186_();
        this.f_119577_ = boss.m_20189_();
        this.volumeControl = new ControlledAnimation(5);
        this.volumeControl.setTimer(3);
        this.f_119573_ = this.volumeControl.getAnimationFraction() * music.volumeControl.getAnimationFraction();
        this.shouldPlay = true;
    }

    public boolean m_7767_() {
        return true;
    }

    public void m_7788_() {
        if (this.shouldPlay) {
            this.volumeControl.increaseTimer();
        } else {
            this.volumeControl.decreaseTimer();
        }
        if ((double)this.f_119573_ < 0.025) {
            this.m_119609_();
        }
        this.f_119573_ = this.volumeControl.getAnimationFraction() * this.music.volumeControl.getAnimationFraction();
    }

    public void setBoss(MowzieEntity boss) {
        this.boss = boss;
    }

    public MowzieEntity getBoss() {
        return this.boss;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public void doStop() {
        this.m_119609_();
    }

    public void fadeOut() {
        this.shouldPlay = false;
    }

    public void fadeIn() {
        this.shouldPlay = true;
    }

    public void cutIn() {
        this.shouldPlay = true;
        this.volumeControl.setTimer(40);
    }

    public void cutOut() {
        this.shouldPlay = false;
        this.volumeControl.setTimer(0);
    }

    public boolean m_7784_() {
        return true;
    }
}

