/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.AdvancedTerrainParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.TerrainParticleData;
import com.bobmowzie.mowziesmobs.client.sound.IGeomancyRumbler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.bluff.EntityBluff;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityEarthSpike;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityFissurePiece;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityFissure
extends Projectile
implements IGeomancyRumbler {
    public static int TICKS_PER_PIECE = 5;
    private static final EntityDataAccessor<Boolean> TRAVELLING = SynchedEntityData.m_135353_(EntityFissure.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int despawnTimer = 0;

    public EntityFissure(EntityType<? extends EntityFissure> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(TRAVELLING, (Object)true);
    }

    public boolean isTravelling() {
        return (Boolean)this.m_20088_().m_135370_(TRAVELLING);
    }

    public void setTravelling(boolean travelling) {
        this.m_20088_().m_135381_(TRAVELLING, (Object)travelling);
    }

    public void shoot(double vx, double vz) {
        float speed = 2.0f / (float)TICKS_PER_PIECE;
        Vec3 vec3 = new Vec3(vx, 0.0, vz).m_82541_().m_82490_((double)speed);
        this.m_20256_(vec3);
        this.m_146922_(-((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)));
        this.f_19859_ = this.m_146908_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isTravelling()) {
            this.stepForwardTrace();
        }
        if (this.f_19797_ > 60 && this.isTravelling()) {
            this.spawnSpike();
        }
        if (this.despawnTimer > 0) {
            --this.despawnTimer;
            if (this.despawnTimer == 1) {
                this.m_146870_();
            }
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.isTravelling() && (float)(this.f_19797_ % TICKS_PER_PIECE) == 1.0f) {
                EntityFissurePiece piece = new EntityFissurePiece((EntityType)EntityHandler.FISSURE_PIECE.get(), this.m_9236_());
                piece.m_146884_(this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)((float)TICKS_PER_PIECE / 3.0f))));
                piece.m_146922_(this.m_146908_());
                piece.setOwner(this);
                this.m_9236_().m_7967_((Entity)piece);
            }
            if (this.isTravelling() && !this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.3), e -> e.m_271807_() && e != this.m_19749_() && !(e instanceof EntityBluff)).isEmpty()) {
                this.spawnSpike();
            }
        } else {
            if (this.f_19797_ == 1) {
                MowziesMobs.PROXY.playGeomancyRumbleSound(this);
            }
            if (this.isTravelling()) {
                BlockState blockBeneath = this.m_9236_().m_8055_(this.m_20097_());
                for (int i = 0; i < 10; ++i) {
                    Vec3 offset = new Vec3((double)this.f_19796_.m_188501_() * 0.45, 0.0, 0.0).m_82524_(this.f_19796_.m_188501_() * (float)Math.PI * 2.0f);
                    Vec3 vel = offset.m_82541_().m_82490_(this.f_19796_.m_188583_() * 0.12).m_82524_(this.f_19796_.m_188501_() * 0.2f - 0.1f).m_82520_(0.0, this.f_19796_.m_188500_() * 0.25 + 0.02, 0.0).m_82549_(this.m_20184_().m_82490_(0.4));
                    AdvancedTerrainParticle.spawnTerrainParticle(this.m_9236_(), (ParticleType<TerrainParticleData>)((ParticleType)ParticleHandler.TERRAIN.get()), this.m_20185_() + offset.f_82479_, this.m_20186_(), this.m_20189_() + offset.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_, 0.0, (double)0.4f + this.f_19796_.m_188583_() * 0.3, 0.94f, 20.0f + this.f_19796_.m_188501_() * 5.0f, blockBeneath, new ParticleComponent[]{new ParticleComponent.Gravity(1.0f)});
                }
            }
        }
    }

    public void stepForwardTrace() {
        Vec3 forwardPos = this.m_20182_().m_82549_(this.m_20184_());
        Vec3 startPos = forwardPos.m_82520_(0.0, 1.1, 0.0);
        Vec3 endPos = forwardPos.m_82520_(0.0, -1.1, 0.0);
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (result.m_6662_() != HitResult.Type.BLOCK || result.m_82436_()) {
            this.spawnSpike();
            return;
        }
        this.m_146884_(result.m_82450_());
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundTeleportEntityPacket((Entity)this));
        }
    }

    private void spawnSpike() {
        if (this.isTravelling()) {
            if (!this.m_9236_().m_5776_()) {
                BlockState state = this.m_9236_().m_8055_(this.m_20097_());
                if (!EffectGeomancy.isBlockUseable(state)) {
                    state = Blocks.f_50493_.m_49966_();
                }
                EntityEarthSpike spike = new EntityEarthSpike((EntityType<? extends EntityMagicEffect>)((EntityType)EntityHandler.EARTH_SPIKE.get()), this.m_9236_(), (LivingEntity)this.m_19749_(), state);
                spike.m_146884_(this.m_20182_());
                spike.m_146922_(this.m_146908_());
                this.m_9236_().m_7967_((Entity)spike);
            }
            this.setTravelling(false);
            this.despawnTimer = 180;
            this.m_20334_(0.0, 0.0, 0.0);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("despawnTimer", (short)this.despawnTimer);
        compound.m_128379_("travelling", this.isTravelling());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.despawnTimer = compound.m_128448_("despawnTimer");
        this.setTravelling(compound.m_128471_("travelling"));
    }

    @Override
    public boolean isRumbling() {
        return this.isTravelling();
    }

    @Override
    public boolean isFinishedRumbling() {
        return !this.isTravelling();
    }

    @Override
    public float getRumblerX() {
        return (float)this.m_20185_();
    }

    @Override
    public float getRumblerY() {
        return (float)this.m_20186_();
    }

    @Override
    public float getRumblerZ() {
        return (float)this.m_20189_();
    }

    @Override
    public float getRumblePitch() {
        return 1.3f;
    }

    @Override
    public float getRumbleVolume() {
        return 0.5f;
    }
}

