/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message.mouse;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.power.Power;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageRightMouseDown {
    public static void serialize(MessageRightMouseDown message, FriendlyByteBuf buf) {
    }

    public static MessageRightMouseDown deserialize(FriendlyByteBuf buf) {
        MessageRightMouseDown message = new MessageRightMouseDown();
        return message;
    }

    public static final class Handler
    implements BiConsumer<MessageRightMouseDown, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessageRightMouseDown message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            ServerPlayer player = context.getSender();
            context.enqueueWork(() -> this.accept(message, player));
            context.setPacketHandled(true);
        }

        @Override
        private void accept(MessageRightMouseDown message, ServerPlayer player) {
            if (player != null) {
                AbilityCapability.IAbilityCapability abilityCapability;
                PlayerCapability.IPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
                if (capability != null) {
                    capability.setMouseRightDown(true);
                    Power[] powers = capability.getPowers();
                    for (int i = 0; i < powers.length; ++i) {
                        powers[i].onRightMouseDown((Player)player);
                    }
                }
                if ((abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player)) != null) {
                    for (Ability ability : abilityCapability.getAbilities()) {
                        if (!(ability instanceof PlayerAbility)) continue;
                        ((PlayerAbility)ability).onRightMouseDown((Player)player);
                    }
                }
            }
        }
    }
}

