/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.StructureTypeHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberPieces;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class WroughtnautChamberStructure
extends MowzieStructure {
    public static final Codec<WroughtnautChamberStructure> CODEC = WroughtnautChamberStructure.m_226607_(WroughtnautChamberStructure::new);

    public WroughtnautChamberStructure(Structure.StructureSettings settings) {
        super(settings, ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig, StructureTypeHandler.FERROUS_WROUGHTNAUT_BIOMES, false, false, true);
    }

    @Override
    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int x = context.f_226628_().m_151390_();
        int z = context.f_226628_().m_151393_();
        int y = context.f_226622_().m_223235_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
        Pair<BlockPos, Rotation> tryResult = WroughtnautChamberStructure.tryWroughtChamber(context.f_226622_(), context.f_226629_(), x, y, z, context.f_226624_());
        if (tryResult == null) {
            return;
        }
        BlockPos pos = (BlockPos)tryResult.getLeft();
        Rotation rotation = (Rotation)tryResult.getRight();
        BlockPos rotationOffset = new BlockPos(0, 0, -9).m_7954_(rotation);
        pos = pos.m_121955_((Vec3i)rotationOffset);
        WroughtnautChamberPieces.start(context.f_226625_(), pos, rotation, (StructurePieceAccessor)builder);
    }

    @Nullable
    public static Pair<BlockPos, Rotation> tryWroughtChamber(ChunkGenerator generator, LevelHeightAccessor heightAccessor, int x, int surfaceY, int z, RandomState state) {
        int xzCheckDistance = 8;
        int heightMax = ((Double)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.heightMax.get()).intValue();
        int heightMin = ((Double)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.heightMin.get()).intValue();
        if (heightMax == -65 || heightMax > surfaceY) {
            heightMax = surfaceY;
        }
        if (heightMin == -65) {
            heightMin = -64;
        }
        for (int dx = -xzCheckDistance; dx < xzCheckDistance; dx += 2) {
            for (int dz = -xzCheckDistance; dz < xzCheckDistance; dz += 2) {
                BlockPos airPos = null;
                NoiseColumn column = generator.m_214184_(x + dx, z + dz, heightAccessor, state);
                for (int y = heightMax; y > heightMin; --y) {
                    if (column.m_183556_(y).m_280296_()) continue;
                    airPos = new BlockPos(x + dx, y, z + dz);
                    break;
                }
                if (airPos == null) continue;
                BlockPos groundPos = null;
                for (int y = airPos.m_123342_(); y > heightMin; --y) {
                    if (!column.m_183556_(y).m_280296_()) continue;
                    groundPos = airPos.m_175288_(y);
                    break;
                }
                if (groundPos == null) continue;
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos.MutableBlockPos checkWallPos = groundPos.m_7494_().m_122032_();
                    for (int d = 1; d <= xzCheckDistance; ++d) {
                        BlockState wallBlock;
                        checkWallPos.m_122173_(dir);
                        NoiseColumn wallCheckColumn = generator.m_214184_(checkWallPos.m_123341_(), checkWallPos.m_123343_(), heightAccessor, state);
                        int wallBaseY = checkWallPos.m_123342_() - 1;
                        int wallHeightCount = 1;
                        while ((wallBlock = wallCheckColumn.m_183556_(checkWallPos.m_123342_())).m_280296_()) {
                            if (wallHeightCount == 4) {
                                Rotation rotation = switch (dir) {
                                    case Direction.NORTH -> Rotation.COUNTERCLOCKWISE_90;
                                    case Direction.EAST -> Rotation.NONE;
                                    case Direction.WEST -> Rotation.CLOCKWISE_180;
                                    default -> Rotation.CLOCKWISE_90;
                                };
                                return Pair.of((Object)new BlockPos(checkWallPos.m_123341_(), wallBaseY, checkWallPos.m_123343_()), (Object)rotation);
                            }
                            checkWallPos.m_122173_(Direction.UP);
                            ++wallHeightCount;
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureTypeHandler.WROUGHTNAUT_CHAMBER.get();
    }
}

